import { fetchSuppliers } from '@/services/SuppliersServices'
import { settingsPurchaseOrders } from '@/services/orders/PurchaseOrdersService'
import { getAllSupplierPricingTiers } from '@/services/SupplierPricingTiersService'
import Vue from 'vue'
import { isEqual, reject } from 'lodash'

export const SuppliersModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    drawerMode: null,
    loading: false,
    allPricingTiersLoading: false,

    itemByIdLoading: false,
    selectedItem: null,

    editedSupplier: {
      name: '',
      email: '',
      phone: '',
      fax: '',
      company_name: '',
      primary_contact_name: null,
      website: '',
      purchase_order_email: ''
    },
    uniqueNameError: false,

    pricingTiers: {
      editedSupplier: [],
      all: []
    },

    editedAddress: {
      label: '',
      name: '',
      company: '',
      phone: '',
      address1: '',
      address2: '',
      address3: '',
      province: '',
      province_code: '',
      city: '',
      zip: '',
      country: '',
      country_code: ''
    },

    editedDefaultWarehouseId: '',

    editedSettings: {
      purchase_order_format: null,
      default_pricing_tier: null,
      leadtime: null,
      minimum_order_quantity: null,
      minimum_purchase_order: null,
      default_shipping_method: null,
      default_store_id: null,
      default_stock_level: 'in_stock',
      timezone: null,
    },

    editedPurchaseSettings: {
      po_processing_method: 'individually',
      processingTime1: { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false },
      processingTime2: { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false },
      processingTime3: { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false },
      auto_fulfill_dropship: 0,
      auto_submit_dropship_po: 0,
      auto_generate_backorder_po: 0,
      auto_submit_backorder_po: 0,
      auto_receive_backorder_po: 0,
      generateTime1: { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false },
      generateTime2: { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false },
      generateTime3: { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false },
      auto_split_backorder_po_by_brand: 0,
    },
    batchScheduleChanged: false,
    backorderScheduleChanged: false,

    warehouseModal: {
      show: false,
      mode: 'create', // 'edit'
      title: 'Create Supplier Warehouse'
    },

    supplierDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },
    purchaseOrderSettings: null,

    dashboardData: {
      loading: false,
      analytics: {},
      chart: [],
    }

  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,

    getDrawerMode: state => state.drawerMode,
    getItemByIdLoading: state => state.itemByIdLoading,
    getSelectedItem: state => state.selectedItem,
    getSelectedItemIndex: state => {
      if (!state.selectedItem) return 0
      return state.itemsList.findIndex(i => i.id === state.selectedItem.id)
    },

    getEditedSupplier: state => state.editedSupplier,
    getEditedSupplierFields: state => ['name', 'email', 'company_name', 'primary_contact_name',
      'website', 'purchase_order_email'],
    getUniqueNameError: state => state.uniqueNameError,
    getPricingTiers: state => state.pricingTiers,

    getEditedAddress: state => state.editedAddress,
    getAddressFields () {
      return ['name', 'company', 'phone', 'fax', 'address1', 'address2', 'address3', 'province',
        'province_code', 'city', 'zip', 'country', 'country_code'
      ]
    },

    getEditedDefaultWarehouseId: state => state.editedDefaultWarehouseId,

    getEditedSettings: state => state.editedSettings,
    getEditedPurchaseSettings: state => state.editedPurchaseSettings,
    getEditedSettingsFields: state => [
      'purchase_order_format',
      'default_pricing_tier',
      'leadtime',
      'minimum_order_quantity',
      'minimum_purchase_order',
      'default_shipping_method',
      'default_store_id',
      'default_stock_level',
      'default_tax_rate_id',
      'timezone',
    ],

    getPurchaseBatchMethodChanged: (state, getters) => {
      if (!state.editedPurchaseSettings.po_processing_method || !state.selectedItem || !state.selectedItem.po_processing_method) return false
      return state.editedPurchaseSettings.po_processing_method !== state.selectedItem.po_processing_method
    },

    getAutoFulfillDropshipChanged: (state, getters) => {
      if (!state.selectedItem) return false
      return state.editedPurchaseSettings.auto_fulfill_dropship !== state.selectedItem.auto_fulfill_dropship
    },

    getAutoSubmitDropshipPurchaseOrderChanged: (state, getters) => {
      if (!state.selectedItem) return false
      return state.editedPurchaseSettings.auto_submit_dropship_po !== state.selectedItem.auto_submit_dropship_po
    },

    getAutoSubmitBackorderPurchaseOrderChanged: (state, getters) => {
      if (!state.selectedItem) return false
      return state.editedPurchaseSettings.auto_submit_backorder_po !== state.selectedItem.auto_submit_backorder_po
    },

    getAutoReceiveBackorderPurchaseOrderChanged: (state, getters) => {
      if (!state.selectedItem) return false
      return state.editedPurchaseSettings.auto_receive_backorder_po !== state.selectedItem.auto_receive_backorder_po
    },

    getSplitSupplierPurchaseOrderByBrandChanged: state => {
      if (!state.selectedItem) return false
      return state.editedPurchaseSettings.auto_split_backorder_po_by_brand !== state.selectedItem.auto_split_backorder_po_by_brand
    },

    getAutogenerateBackorderChanged: (state, getters) => {
      // it can be 'false'
      if ([null, undefined].includes(state.editedPurchaseSettings.auto_generate_backorder_po) || !state.selectedItem || [null, undefined].includes(state.selectedItem.auto_generate_backorder_po)) return false
      return state.editedPurchaseSettings.auto_generate_backorder_po !== state.selectedItem.auto_generate_backorder_po
    },

    getBatchScheduleChanged: state => state.batchScheduleChanged,
    getBackorderScheduleChanged: state => state.backorderScheduleChanged,

    getSupplierDetailsChanged: (state, getters) => {
      if (state.selectedItem) {
        let detailsBefore = {}
        let detailsNow = {}
        getters.getEditedSupplierFields.forEach(f => {
          detailsBefore[f] = state.selectedItem[f] || ''
          detailsNow[f] = state.editedSupplier[f] || ''
        })
        return !isEqual(detailsBefore, detailsNow)
      } else {
        return false
      }
    },
    getPricingTiersChanged: (state) => {
      if (state.selectedItem && state.selectedItem.pricing) {
        return !isEqual(state.selectedItem.pricing, state.pricingTiers.editedSupplier)
      }
      return false
    },

    getDefaultWarehouseChanged: (state) => {
      if (state.selectedItem && state.editedDefaultWarehouseId) {
        const initialDefaultWarehouseId = state.selectedItem.default_warehouse_id

        if (initialDefaultWarehouseId) {
          return initialDefaultWarehouseId !== state.editedDefaultWarehouseId
        } else if (!initialDefaultWarehouseId && state.editedDefaultWarehouseId) {
          return true
        } else {
          return false
        }
      } else {
        return false
      }
    },
    getAddressChanged: (state, getters) => {
      if (state.selectedItem && state.selectedItem.address) {
        let addressBefore = {}
        let addressNow = {}
        getters.getAddressFields.forEach(f => {
          addressBefore[f] = state.selectedItem.address[f] || ''
          addressNow[f] = state.editedAddress[f] || ''
        })
        return !isEqual(addressBefore, addressNow)
      } else {
        return false
      }
    },
    getSettingsChanged: (state, getters) => {
      if (state.selectedItem) {
        let settingsBefore = {}
        let settingsNow = {}
        getters.getEditedSettingsFields.forEach(f => {
          if (state.selectedItem[f] && state.selectedItem[f].id && state.editedSettings[f] && state.editedSettings[f].id) {
            settingsBefore[f] = state.selectedItem[f].id || ''
            settingsNow[f] = state.editedSettings[f].id || ''
          } else {
            if (state.selectedItem[f] || state.selectedItem[f] === 0 || state.selectedItem[f] === '') {
              settingsBefore[f] = state.selectedItem[f]
            } else {
              settingsBefore[f] = '-1'
            }
            if (state.editedSettings[f] || state.editedSettings[f] === 0 || state.editedSettings[f] === '') {
              settingsNow[f] = state.editedSettings[f]
            } else {
              settingsNow[f] = '-1'
            }
          }
        })
        return !isEqual(settingsBefore, settingsNow)
      } else {
        return false
      }
    },
    getSomethingChanged: (_, getters) => {
      return getters.getPricingTiersChanged || getters.getAddressChanged || getters.getSupplierDetailsChanged ||
        getters.getSettingsChanged || getters.getDefaultWarehouseChanged || getters.getPurchaseBatchMethodChanged ||
        getters.getAutoFulfillDropshipChanged || getters.getAutoSubmitDropshipPurchaseOrderChanged ||
        getters.getAutogenerateBackorderChanged || getters.getBackorderScheduleChanged || getters.getBatchScheduleChanged ||
        getters.getAutoSubmitBackorderPurchaseOrderChanged || getters.getAutoReceiveBackorderPurchaseOrderChanged ||
        getters.getSplitSupplierPurchaseOrderByBrandChanged
    },
    getWarehouseModal: state => state.warehouseModal,

    getSupplierDrawer: state => state.supplierDrawer,
    getPOSettings: state => state.purchaseOrderSettings,
    getAllPricingTiersLoading: state => state.allPricingTiersLoading,

    getDashboardAnalytics: state => state.dashboardData.analytics,
    getDashboardLoading: state => state.dashboardData.loading,
    getDashboardChartData: state => state.dashboardData.chart,
    getEditedPOSettingFields: state => [
      'auto_fulfill_dropship','auto_submit_dropship_po','auto_generate_backorder_po',
      'auto_submit_backorder_po','auto_receive_backorder_po','auto_split_backorder_po_by_brand',
    ],
  },
  mutations: {
    SET_BATCH_SCHEDULE_CHANGED (state, value) {
      state.batchScheduleChanged = value
    },
    SET_BACKORDER_SCHEDULE_CHANGED (state, value) {
      state.backorderScheduleChanged = value
    },
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_ITEM_BY_ID_LOADING (state, value) {
      state.itemByIdLoading = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_SELECTED_ITEM_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.selectedItem, field, value)
    },
    SET_SELECTED_ITEM_WAREHOUSES (state, value) {
      Vue.prototype.$set(state.selectedItem, 'warehouses', value)
    },

    DELETE_ADDRESS_BY_ID (state, id) {
      const deleteIndex = state.selectedItem.addresses.findIndex(a => a.id === id)

      if (deleteIndex) {
        state.selectedItem.addresses.splice(deleteIndex, 1)
      }
    },
    UPDATE_ADDRESS (state, address) {
      const updateIndex = state.selectedItem.addresses.findIndex(a => a.id === address.id)

      if (updateIndex || updateIndex === 0) {
        Vue.prototype.$set(state.selectedItem.addresses, updateIndex, address)
      }
    },
    ADD_ADDRESS (state, address) {
      state.selectedItem.addresses.push(address)
    },

    SET_EDITED_SUPPLIER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedSupplier, field, value)
    },
    SET_UNIQUE_NAME_ERROR (state, value) {
      state.uniqueNameError = value
    },

    SET_EDITED_WAREHOUSE_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedWarehouse, field, value)
    },

    SET_PRICING_TIERS (state, { type, value }) {
      Vue.prototype.$set(state.pricingTiers, type, value)
    },

    RESET_PRICING_TIERS (state) {
      state.pricingTiers = {
        editedSupplier: [],
        all: []
      }
    },

    SET_EDITED_ADDRESS (state, value) {
      state.editedAddress = value
    },
    SET_EDITED_ADDRESS_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedAddress, field, value)
    },
    RESET_EDITED_ADDRESS (state) {
      state.editedAddress = {
        label: '',
        name: '',
        company: '',
        phone: '',
        fax: '',
        address1: '',
        address2: '',
        address3: '',
        province: '',
        province_code: '',
        city: '',
        zip: '',
        country: '',
        country_code: ''
      }
    },
    SET_EDITED_DEFAULT_WAREHOUSE_ID (state, value) {
      state.editedDefaultWarehouseId = value
    },

    SET_EDITED_SETTINGS_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedSettings, field, value)
    },
    SET_EDITED_PURCHASE_SETTINGS_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedPurchaseSettings, field, value)
    },
    RESET_ALL_PROCESSING_TIME (state) {
      state.editedPurchaseSettings.processingTime1 = { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false }
      state.editedPurchaseSettings.processingTime2 = { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false }
      state.editedPurchaseSettings.processingTime3 = { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false }
    },
    RESET_ALL_GENERATE_TIME (state) {
      state.editedPurchaseSettings.generateTime1 = { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false }
      state.editedPurchaseSettings.generateTime2 = { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false }
      state.editedPurchaseSettings.generateTime3 = { time: null, monday: false, tuesday: false, wednesday: false, thursday: false, friday: false, saturday: false, sunday: false }
    },
    SET_WAREHOUSE_MODAL (state, value) {
      state.warehouseModal = value
    },
    SET_WAREHOUSE_MODAL_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.warehouseModal, field, value)
    },

    SET_SUPPLIER_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.supplierDrawer, field, value)
    },
    SET_PO_SETTINGS (state, value) {
      state.purchaseOrderSettings = value
    },
    SET_LOADING_ALL_PRICING_TIERS (state, value) {
      state.allPricingTiersLoading = value
    },
    SET_DASHBOARD_DATA (state, {field,value}) {
      Vue.prototype.$set(state.dashboardData, field, value)
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await fetchSuppliers(query)

        commit('SET_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await fetchSuppliers(query)

        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await fetchSuppliers(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchPOSettings ({ commit }) {
      try {
        commit('SET_LOADING', true)
        const response = await settingsPurchaseOrders()
        commit('SET_PO_SETTINGS', response.data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async fetchAllSupplierPricingTiers ({ commit, getters }) {
      commit('SET_LOADING_ALL_PRICING_TIERS', true)
      try {
        // we need to build a list of pricing tiers to select from. selected pricing tiers would go first
        // they would include both archived and active pricing tiers. then we want to add other pricing tiers,
        // but only active ones (excluding archived)
        const activePricingTiers = await getAllSupplierPricingTiers({ limit: -1, archived: 0 })
        const archivedPricingTiers = await getAllSupplierPricingTiers({ limit: -1, archived: 1 })
        const allPricingTiers = [...activePricingTiers.data, ...archivedPricingTiers.data]

        const selectedPricingTiers = allPricingTiers.filter(p => !!getters.getPricingTiers.editedSupplier.find(vp => vp.id === p.id))
        const activePricingTiersWithoutSelected = reject(activePricingTiers.data, (p) => !!getters.getPricingTiers.editedSupplier.find(vp => vp.id === p.id))

        commit('SET_PRICING_TIERS', { type: 'all', value: [...selectedPricingTiers, ...activePricingTiersWithoutSelected] })
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING_ALL_PRICING_TIERS', false)
      }
    }
  }
}
