import { getAllStockTakes } from '@/services/StockTakesService'
import Vue from 'vue'
import { lookupStockTakesValues } from '@/services/LookupService'

const initItemObject = {
  status: null,
  created_at: null,
  updated_at: null,
  date_count: null,
  warehouse: {},
  items: []
}

export const StockTakesModule = {
  namespaced: true,
  state: {
    stockTakesList: [],
    selectedItem: {
      status: null,
      created_at: null,
      updated_at: null,
      date_count: null,
      warehouse: {},
      items: []
    },
    maxPages: 0,
    meta: {},
    loading: false,
    tableSpecifications: {},
    stockTakeDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: null
    },
    drawerMode: null,
    editingItem: {
      status: null,
      created_at: null,
      updated_at: null,
      date_count: null,
      warehouse: {},
      items: []
    },
    addProductDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: null
    },
    addProductDrawerMode: 'add'
  },
  getters: {
    getItemsList: state => state.stockTakesList,
    getSelectedItem: state => state.selectedItem,
    getMaxPages: state => Number(state.maxPages),
    getMeta: state => state.meta,
    getDrawerMode: state => state.drawerMode,
    getStockTakeDrawer: state => state.stockTakeDrawer,
    getStockTakeAddProductDrawer: state => state.addProductDrawer,
    getStockTakeAddProductDrawerMode: state => state.addProductDrawerMode,
    getTableSpecifications: state => state.tableSpecifications,
    getSelectedItemIndex: state => {
      if (!state.selectedItem) return -1
      return state.stockTakesList.findIndex(item => item.id === state.selectedItem.id)
    },
    getEditingItem: state => state.editingItem,
    getLoading: state => state.loading
  },
  mutations: {
    SET_ALL_STOCK_TAKES (state, stockTakes) {
      state.stockTakesList = stockTakes
    },
    SET_SELECTED_ITEM (state, stockTake) {
      Vue.prototype.$set(state, 'selectedItem', stockTake)
    },
    // Set Max Pages Mutation
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_STOCK_TAKES_META (state, meta) {
      state.meta = meta
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_STOCK_TAKES_ADD_PRODUCT_DRAWER_MODE (state, value) {
      state.addProductDrawerMode = value
    },
    SET_STOCK_TAKES_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.stockTakeDrawer, field, value)
    },
    SET_STOCK_TAKES_ADD_PRODUCT_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.addProductDrawer, field, value)
    },
    SET_TABLE_SPECIFICATIONS (state, specifications) {
      state.tableSpecifications = specifications
    },
    SET_EDITING_ITEM (state, stockTake) {
      Vue.prototype.$set(state, 'editingItem', stockTake)
    },
    SET_EDITING_ITEM_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editingItem, field, value)
    },
    SET_INIT_EDITING_ITEM (state) {
      Vue.prototype.$set(state, 'editingItem', initItemObject)
    },
    SET_INIT_SELECTED_ITEM (state) {
      Vue.prototype.$set(state, 'selectedItem', initItemObject)
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {

    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getAllStockTakes(query)
        commit('SET_ALL_STOCK_TAKES', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllStockTakes(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_STOCK_TAKES_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllStockTakes(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchLookupValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupStockTakesValues({ value, header, page, limit })
      } catch (e) {

      }
    }
  }
}
