import { getAllShippingMethod, getShippingMethodByID } from '@/services/ShippingMethodsService'
import Vue from 'vue'
import { cloneDeep } from 'lodash'

export const ShippingMethodsModule = {
  namespaced: true,
  state: {
    itemsList: [],
    shippingMethodsLoading: false,
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    selectedShippingMethod: {},
    selectedType: null,
    disableSaveByEnter: false,

    drawerMode: null,
    shippingMethodDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },

    createWithInitialName: ''
  },
  getters: {
    getShippingMethodsLoading: state => state.shippingMethodsLoading,
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getSelectedShippingMethod: state => state.selectedShippingMethod,
    getSelectedType: state => state.selectedType,
    getSelectedIndex: (state, getters) => {
      return getters.getItemsList.findIndex(s => s.id === getters.getSelectedShippingMethod.id)
    },
    getSelectedExcludedLocations: (state, getters, rootState, rootGetters) => {
      let filter = getters.getSelectedShippingMethod.excluded_locations || []
      return cloneDeep(rootGetters['ConstantsModule/getCountriesGrouped']).filter(
        el => {
          return el.children.filter(ch => filter.includes(ch.code)).length
        }
      ).map(el => {
        el.children = el.children.filter(
          el => {
            return filter.includes(el.code)
          }
        )
        return el
      })
    },
    getSelectedIncludedLocations: (state, getters, rootState, rootGetters) => {
      let filter = getters.getSelectedShippingMethod.included_locations || []
      return cloneDeep(rootGetters['ConstantsModule/getCountriesGrouped']).filter(
        el => {
          return el.children.filter(ch => filter.includes(ch.code)).length
        }
      ).map(el => {
        el.children = el.children.filter(
          el => {
            return filter.includes(el.code)
          }
        )
        return el
      })
    },
    getDisableSaveByEnterStatus: state => state.disableSaveByEnter,

    getDrawerMode: state => state.drawerMode,
    getShippingMethodDrawer: state => state.shippingMethodDrawer,

    getCreateWithInitialName: state => state.createWithInitialName
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_SHIPPING_METHODS_LOADING (state, value) {
      state.shippingMethodsLoading = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_SELECTED_SHIPPING_METHOD (state, shippingMethod) {
      state.selectedShippingMethod = shippingMethod
      // Update shippingMethod in list
      const index = state.itemsList.findIndex(c => c.id === state?.selectedShippingMethod?.id)
      if (index !== -1) { Vue.set(state.itemsList, index, cloneDeep(shippingMethod)) }
    },
    SET_DISPLAY_AS (state, value) {
      state.selectedType = value
    },
    SET_DISABLE_SAVE_BY_ENTER (state, value) {
      state.disableSaveByEnter = value
    },

    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_SHIPPING_METHOD_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.shippingMethodDrawer, field, value)
    },
    SET_CREATE_WITH_INITIAL_NAME (state, value) {
      state.createWithInitialName = value
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_SHIPPING_METHODS_LOADING', true)
        const response = await getAllShippingMethod(query)

        commit('SET_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
        commit('SET_SHIPPING_METHODS_LOADING', false)
      } catch (e) {
        throw e
      }
    },
    async getItemByIdRequest ({ commit }, ID) {
      try {
        commit('SET_SHIPPING_METHODS_LOADING', true)

        const response = await getShippingMethodByID(ID)
        commit('SET_SELECTED_SHIPPING_METHOD', response.data)

        commit('SET_SHIPPING_METHODS_LOADING', false)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllShippingMethod(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllShippingMethod(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    setSelectedShippingMethod ({ commit, getters }, shippingMethod) {
      commit('SET_SELECTED_SHIPPING_METHOD', shippingMethod)
    }
  }
}
