import Vue from 'vue'
import {cloneDeep} from 'lodash'
import {getAllUsers} from '@/services/UserService'

export const SettingsUsersModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    selectedUser: [],
    loading: false
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getSelectedUser: state => state.selectedUser,
    getSelectedIndex: state => state.users.findIndex(c => c.id === state.selectedUser.id)
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_SELECTED_USER (state, user) {
      state.selectedUser = user
      const index = state.users.findIndex(c => c.id === state.user.id)
      if (index !== -1) { Vue.set(state.users, index, cloneDeep(user)) }
    }
  },
  actions: {
    setSelectedUser ({ commit, getters }, user) {
      commit('SET_SELECTED_USER', user)
    },
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getAllUsers(query)
        commit('SET_ITEMS_LIST', response.data?.data)
        if (response.data.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllUsers(query)
        if (response.data?.meta && response.data?.meta.last_page) commit('SET_MAX_PAGES', response.data?.meta.last_page)
        if (response.data?.meta) commit('SET_META', response.data?.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllUsers(query)
        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data?.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    }
  }
}
