import Vue from 'vue'

export const SalesOrderFinancialsModule = {
  namespaced: true,
  state: {
    itemsLoading: false,
    selectedItem: null,
    orderFinancialsDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },

    drawerMode: null // view
  },
  getters: {
    getLoading: state => state.itemsLoading,
    getSelectedItem: state => state.selectedItem,
    getDrawerMode: state => state.drawerMode,
    getOrderFinancialsDrawer: state => state.orderFinancialsDrawer
  },
  mutations: {
    SET_SELECTED_ITEM (state, value) {
      state.getSelectedItem = value
    },
    SET_ITEMS_LOADING (state, value) {
      state.itemsLoading = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.orderFinancialsDrawer, field, value)
    }
  },
  actions: {
  }
}
