import { getAllSalesChannels } from '@/services/SalesChannels'

export const SalesChannels = {
  namespaced: true,
  state: {
    itemsList: [],
    itemsLoading: false,
    tableSpecifications: {},
    maxPages: 0,
    meta: {}
  },
  getters: {
    getItemsList: state => state.itemsList,
    getItemsLoading: state => state.itemsLoading,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_ITEMS_LOADING (state, value) {
      state.itemsLoading = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_ITEMS_LOADING', true)
        const response = await getAllSalesChannels(query)

        commit('SET_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_ITEMS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllSalesChannels(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        return Promise.reject(e)
      }
    }
  }
}
