import {
  getShipByScheduleItems,
} from '@/services/ReportsShipByScheduleService'
import { lookupShipByScheduleValues } from '@/services/LookupService'

export const ReportsShipByScheduleModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    itemsLoading: false,
    itemByIdLoading: false,
    selectedItem: null
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.itemsLoading
  },
  mutations: {
    SET_ITEMS_LIST (state, items) {
      state.itemsList = JSON.parse(JSON.stringify(items))
    },
    SET_ITEMS_LOADING (state, value) {
      state.itemsLoading = value
    },
    SET_ITEM_BY_ID_LOADING (state, value) {
      state.itemByIdLoading = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = JSON.parse(JSON.stringify(value))
    },
    SET_TABLE_SPECIFICATIONS (state, specs) {
      state.tableSpecifications = specs
    },
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_META (state, meta) {
      state.meta = meta
    },
  },
  actions: {

    async getItemsRequest ({ commit, state }, query) {

      try {
        commit('SET_ITEMS_LOADING', true)
        const response = await getShipByScheduleItems(query)

        if (response?.data) commit('SET_ITEMS_LIST', response.data)
        if (response?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_ITEMS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getShipByScheduleItems(query)
        if (response?.meta?.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response?.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getShipByScheduleItems(query)

        if (response?.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchLookupValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupShipByScheduleValues({ value, header, page, limit })
      } catch (e) {
      }
    },
  }
}
