import { getQuickBooksTaxRates, getAccounts } from '@/services/QuickBooksServices'
import { fetchTaxRatesForMapping } from '@/services/TaxRatesService'
import { getTableMetaRequest, getTableSpecificationsRequest, getItemsRequest } from '@/support/tableApiRequestHelpers'

export const QuickBooksModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,
    taxRates: [],
    taxRatesMappings: [],
    instanceId: null,
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getInstanceId: state => state.instanceId,
    getSomethingChanged: (state, getters) => {
      return false
    },
    getQuickBooksTaxRates: state => state.taxRates,
    getQuickBookstaxRatesMappingsData: state => state.taxRatesMappings,
    getQuickBooksTaxRatesMappings: state => state.taxRatesMappings.map(tax => {
      tax.valueChanged = false
      tax.complexName = `${tax.name} (${tax.rate}%)`
      return tax
    })
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_QUICK_BOOKS_TAX_RATES (state, value = []) {
      state.taxRates = value
    },
    SET_QUICK_BOOKS_TAX_RATES_MAPPINGS (state, value = []) {
      state.taxRatesMappings = value.sort((a,b) => a.id > b.id ? 1 : -1)
    },
    SET_INSTANCE_ID (state, value) {
      state.instanceId = value
    }
  },
  actions: {
    async getItemsRequest ({ commit, getters }, query) {
      return getItemsRequest(query, commit, (params) => getAccounts(getters.getInstanceId, params))
    },
    async getMetaRequest ({ commit, getters }, query) {
      return getTableMetaRequest(query, commit, (params) => getAccounts(getters.getInstanceId, params))
    },
    async loadTableSpecifications ({ commit, getters }, query) {
      return getTableSpecificationsRequest(query, commit, (params) => getAccounts(getters.getInstanceId, params))
    },
    async fetchQuickBooksTaxRates ({ commit, getters }) {
      try {
        const {data} = await getQuickBooksTaxRates(getters.getInstanceId)
        commit('SET_QUICK_BOOKS_TAX_RATES', data)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchQuickBooksTaxRatesMappings ({ commit }) {
      try {
        const {data} = await fetchTaxRatesForMapping()
        commit('SET_QUICK_BOOKS_TAX_RATES_MAPPINGS', data)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    }
  }
}
