import { getAllProducts } from '@/services/ProductsService'
import { lookupProductValues } from '@/services/LookupService'
import Vue from 'vue'
export const ProductsTableModule = {
  namespaced: true,
  state: () => ({
    productsList: [],
    maxPages: 0,
    meta: {},
    productsTableConfiguration: {},
    loading: false
  }),
  getters: {
    getTableSpecifications: state => state.productsTableConfiguration,
    getProductsList: state => state.productsList,
    getMaxPages: state => Number(state.maxPages),
    getMeta: state => state.meta,
    getLoading: state => state.loading
  },
  mutations: {
    SET_PRODUCT_AT (state, payload) {
      // state.productsList[payload.index] = payload.product
      Vue.set(state.productsList, payload.index, payload.product)
    },
    SET_ALL_PRODUCTS (state, products) {
      state.productsList = products
    },
    SET_PRODUCTS_TABLE_CONFIGURATION (state, config) {
      state.productsTableConfiguration = config
    },
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_PRODUCTS_META (state, meta) {
      state.meta = meta
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    // Sets product at the given index
    setProductAt ({ commit }, payload) {
      commit('SET_PRODUCT_AT', payload)
    },
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getAllProducts(query)
        commit('SET_ALL_PRODUCTS', response.data)
        if (response.table_specifications) commit('SET_PRODUCTS_TABLE_CONFIGURATION', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllProducts(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_PRODUCTS_META', response.meta)
      } catch (e) {
        throw e
      }
    },

    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllProducts(query)

        if (response.data?.table_specifications) commit('SET_PRODUCTS_TABLE_CONFIGURATION', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },

    async fetchLookupProductValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupProductValues({ value, header, page, limit })
      } catch (e) {

      }
    }
  }
}
