import { getAllSuppliers } from '@/services/SuppliersServices'

export const ProductsSupplierModule = {

  namespaced: true,
  state: {
    product: null,
    suppliers: [],
    productSuppliers: [],
    defaultSupplier: []
  },
  getters: {
    getSuppliers: state => state.suppliers,
    getProductSuppliers: state => state.productSuppliers,
    getProduct: state => state.product
  },
  mutations: {
    SET_ALL_SUPPLIERS (state, suppliers) {
      state.suppliers = suppliers
    },
    SET_PRODUCT_SUPPLIERS (state, suppliers) {
      state.productSuppliers = suppliers
    },
    SET_DEFAULT_SUPPLIER (state, supplier) {
      state.defaultSupplier = supplier
    },
    SET_PRODUCT (state, product) {
      state.product = product
    }
  },
  actions: {
    async fetchAllSuppliers ({ commit }) {
      try {
        const suppliers = (await getAllSuppliers()).data

        suppliers.map(supplier => {
          supplier.pricing = supplier.pricing.map(i => {
            i.supplier_pricing_tier_id = i.id
            i.supplier_pricing_tier_name = i.name
            return i
          })
          supplier.original_leadtime = supplier.leadtime
          supplier.original_minimum_order_quantity = supplier.minimum_order_quantity
          return supplier
        })
        commit('SET_ALL_SUPPLIERS', suppliers)
      } catch (e) {
        throw e
      }
    },
    addSupplier ({ commit, getters }, supplier) {
      // We add the supplier to the suppliers of the product
      const suppliers = getters.getProductSuppliers
      suppliers.push(supplier)
      commit('SET_PRODUCT_SUPPLIERS', suppliers)
    },
    removeSupplier ({ commit, getters }, supplier) {
      const suppliers = getters.getProductSuppliers.filter(v => v.supplier_id !== supplier.supplier_id)
      commit('SET_PRODUCT_SUPPLIERS', suppliers)
    }
  }

}
