import {
  getAllSalesOrders,
  settingsSalesOrders,
  addPayment,
  fetchOrderStarshipitFulfillment,
  getPayments,
  updatePayment,
  compareFulfillmentsWithSalesChannel
} from '@/services/orders/SalesOrdersService'
import { lookupOrdersValues } from '@/services/LookupService'
import { getAllCustomers } from '@/services/orders/CustomersService'
import { getAllShippingCarriers } from '@/services/orders/ShippingCarriersService'
import moment from 'moment-timezone'
import wasArrayChanged from '@/support/wasArrayChanged'
import { cloneDeep, isEqual } from 'lodash'
import exactMath from 'exact-math'
import { getPaymentObject } from '@/support/paymentsHelpers'
import Vue from 'vue'
import { FINANCIALS } from '@/assets/constants'
import { filterLinesByClassification, calculateLinesTotal } from '@/support/financialLinesHelpers'
import { checkIsDateString } from '@/support/timeHelper'

const {COST,REVENUE} = FINANCIALS.LINES.CLASSIFICATIONS

export const OrdersModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    itemsLoading: false,
    itemByIdLoading: false,
    selectedItem: null,
    customers: [],
    customersLoading: false,
    carriers: [], // aka shipping methods
    carriersLoading: false,
    customFields: [],
    customFieldValues: [],
    updatedCustomFieldValues: [],
    displayedCustomFields: [],
    initialCustomFields: [],
    selectedStore: null,
    selectedSalesOrderDefaultStore: null,
    selectedCustomer: null,
    selectedCurrency: null,
    selectedDate: null,
    selectedNumberOfDigits: null,
    selectedShippingMethod: null,
    selectedRequestedShippingMethod: '',
    selectedStartNumber: 1000,
    selectedHandlingDays: 0,
    selectedSameDayShipping: null,
    selectedShowTaxRate: null,
    selectedShowTaxAmount: null,
    selectedPrefix: null,
    selectedShippingMethodInternational: null,
    selectedShippingMethodDomestic: null,
    selectedShipBy: '',
    selectedDeliverBy: '',
    selectedCurrencyRate: '',
    selectedDiscounts: [],
    selectedTaxes: [],
    selectedOrderNumber: '',
    orderProducts: [],
    drawerMode: null, // create, edit, view, payments, and  costs
    addressFields: [
      'name',
      'company',
      'email',
      'phone',
      'address1',
      'address2',
      'address3',
      'city',
      'province',
      'province_code',
      'zip',
      'country',
      'country_code'
    ],
    itemFields: [
      'item_discount',
      'item_name',
      'item_nominal_code',
      'item_nominal_code_code',
      'item_price',
      'item_quantity',
      'tax_rate_id',
      'tax_rate',
      'warehouse',
      'to_delete',
    ],
    fetchedSelectValues: false,
    settings: [],
    settingsLoading: false,
    num_of_digits: [{ value: '4' }, { value: '5' }, { value: '6' }, { value: '7' }],
    shippingChangedForCreateMode: false,
    selectedShippingAddress: null,
    selectedBillingAddress: null,
    defaultSettings: {
      defaultStore: null,
      defaultShippingMethod: null,
      defaultWarehouse: null,
      defaultShipByDate: null,
      defaultDeliverByDate: null,
      defaultCurrency: null
    },
    inventoryWarehouse: {
      showSupplierWarehouseModal: false
    },
    selectedIsTaxIncluded: false,
    selectedTaxRate: {
      tax_rate_id: null,
      tax_rate: null
    },

    orderDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false,
      ignoreItemResetOnLaunch: false
    },

    selectedOrderPayments: [],

    initialValuesAreSet: false,
    salesCreditModal: {
      show: false,
      loading: false
    },
    paymentModal: {
      show: false,
      deleting: false,
      isRefund: false,
      payment: null,
      loading: false
    },
    customFieldModal: {
      show: false,
      deleting: false,
      isRefund: false,
      payment: null,
      loading: false
    },
    customFieldsManageModal: {
      show: false,
      deleting: false,
      isRefund: false,
      payment: null,
      loading: false
    },
    paymentsLoading: false,
    shipByWasManuallySet: false,

    orderAddProductDrawerMode: 'add',
    orderAddProductDrawer: {
      mode: null,
      show: false
    },

    globalSettings: null,
    skuCurrencies: [],
    instanceDetails: null,
    starshiptFulfillment: null,
    instanceStoreUrl: null,
    selectedTags: [],
    productsByWarehouse: new Map(),
    fulfillments: {
      toSubmit: [],
      toCreate: [],
      differences: [],
      toCreateLines: [],
    },
    isLoadedFulfillments: false,
    autogenerateOrderNumber: true,
    editedSettings: {},
    isFetch: false,
    // Financial Lines
    financialLines: [],
    financialLineFields: [
      'allocate_to_products',
      'financial_line_type',
      'proration_strategy',
      'tax_allocation',
      'nominal_code',
      'description',
      'quantity',
      'amount',
    ],
    initialFinancialLines: [],
  },
  getters: {
    getGlobalSettings: state => state.globalSettings,
    getShowTaxAmount: (state, getters) => {
      if (!getters.getGlobalSettings) return false
      let taxAmountObject = getters.getGlobalSettings.find(i => i.key === 'sales_order_show_tax_amount')
      if (!taxAmountObject) return false
      return !!taxAmountObject.value
    },
    getShowTaxRate: (state, getters) => {
      if (!getters.getGlobalSettings) return false
      let taxAmountObject = getters.getGlobalSettings.find(i => i.key === 'sales_order_show_tax_rate')
      if (!taxAmountObject) return false
      return !!taxAmountObject.value
    },
    getShowBarcode: state => {
      if (!state.globalSettings) return false
      const barcodeObj = state.globalSettings.find(i => i.key === 'sales_credit_show_barcode_in_frontend')
      if (!barcodeObj) return false
      return barcodeObj.value
    },
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getItemByIdLoading: state => state.itemByIdLoading,
    getSelectedItem: state => state.selectedItem,
    getIsEditing: state => state.drawerMode === 'create' || (state.drawerMode !== 'view' && state.selectedItem && state.selectedItem.sales_channel_name !== 'Amazon US'),
    getSelectedItemIndex: state => {
      if (!state.selectedItem) return 0
      return state.itemsList.findIndex(i => i.id === state.selectedItem.id)
    },
    getSalesCreditModal: state => state.salesCreditModal,
    getPaymentModal: state => state.paymentModal,
    getCustomFieldModal: state => state.customFieldModal,
    getCustomFieldsManageModal: state => state.customFieldsManageModal,
    getPaymentsLoading: state => state.paymentsLoading,
    getCustomers: state => state.customers,
    getCustomersLoading: state => state.customersLoading,
    getLoading: state => state.itemsLoading,
    getCustomerNotSelected: (state, getters) => {
      return (!getters.getSelectedCustomer || !getters.getSelectedCustomer.id) && getters.getDrawerMode === 'create'
    },
    getCarriers: state => state.carriers,
    getShippingMethods: (state, getters) => {
      let methodsArray = []
      getters.getCarriers.forEach((carrier, index) => {
        carrier.shipping_methods.forEach(method => {
          methodsArray.push({
            ...method,
            id: method.id,
            name: method.name,
            fullName: `${carrier.name} ${method.name}`
          })
        })
      })
      return methodsArray
    },
    getShippingMethodsInternational: (state, getters) => {
      let methodsArray = []
      getters.getCarriers.forEach((carrier, index) => {
        carrier.shipping_methods.forEach(method => {
          if (method.type === 'international') {
            methodsArray.push({
              id: method.id,
              name: method.name,
              fullName: `${carrier.name} ${method.name}`
            })
          }
        })
      })
      return methodsArray
    },
    getShippingMethodsDomestic: (state, getters) => {
      let methodsArray = []
      getters.getCarriers.forEach((carrier, index) => {
        carrier.shipping_methods.forEach(method => {
          if (method.type === 'domestic') {
            methodsArray.push({
              id: method.id,
              name: method.name,
              fullName: `${carrier.name} ${method.name}`
            })
          }
        })
      })
      return methodsArray
    },
    getCarriersLoading: state => state.carriersLoading,
    getSelectedStore: state => state.selectedStore,
    getStoreChanged: state => {
      const initialValue = (state.selectedItem?.store && state.selectedItem?.store?.id) || '-'
      const localValue = (state.selectedStore && state.selectedStore.id) || '-'
      return localValue !== initialValue
    },
    getSelectedCustomer: state => {
      const customer = JSON.parse(JSON.stringify(state.selectedCustomer))
      if (customer && customer.addresses) {
        customer.addresses = customer.addresses.map(a => {
          a.is_default_shipping = a.is_default_shipping || false
          a.is_default_billing = a.is_default_billing || false
          return a
        })
      }
      return customer
    },
    getCustomerChanged: state => {
      const initialValue = (state.selectedItem?.customer_name && state.selectedItem?.customer_name?.id) || '-'
      const localValue = (state.selectedCustomer && state.selectedCustomer?.id) || '-'
      return localValue !== initialValue
    },
    getSelectedShippingAddress: state => state.selectedShippingAddress,
    getShippingAddressChanged: state => {
      if (!state.selectedItem || !state.selectedItem?.sales_order_shipping_address) return false

      return state.selectedItem?.sales_order_shipping_address?.id !== state.selectedShippingAddress?.id
    },
    getSelectedBillingAddress: state => state.selectedBillingAddress,
    getBillingAddressChanged: state => {
      if (!state.selectedItem || !state.selectedItem?.sales_order_billing_address) return false

      return state.selectedItem?.sales_order_billing_address?.id !== state.selectedBillingAddress.id
    },
    getShippingSameAsBilling: state => {
      if (state.selectedShippingAddress && state.selectedBillingAddress) {
        return state.selectedShippingAddress.id === state.selectedBillingAddress.id
      }
      return false
    },
    getAddressFields: state => state.addressFields,
    getItemFields: state => state.itemFields,
    getSelectedCurrency: state => state.selectedCurrency,
    getCurrencyChanged: state => {
      const initialValue = state.selectedItem?.currency_code || '-'
      const localValue = (state.selectedCurrency && state.selectedCurrency?.code) || '-'
      return localValue !== initialValue
    },
    getSelectedDate: state => state.selectedDate,
    getDateChanged: (state, getters) => {
      if (!state.selectedItem || !getters.getSelectedDate) return false
      const initialValue = moment(state.selectedItem?.order_date).format() || '-'
      const localValue = moment(getters.getSelectedDate).format() || '-'
      return initialValue !== localValue
    },
    getSelectedRequestedShippingMethod: state => state.selectedRequestedShippingMethod,
    getRequestedShippingMethodChanged: (state, getters) => {
      if (!state.selectedItem) return false
      const initialValue = state.selectedItem?.requested_shipping_method || '-'
      const localValue = getters.getSelectedRequestedShippingMethod || '-'
      return initialValue !== localValue
    },
    getSelectedShippingMethod: state => state.selectedShippingMethod,
    getSelectedShippingMethodInternational: (state, getters) => {
      if (state.selectedShippingMethodInternational) return state.selectedShippingMethodInternational
      const selectedShippingMethodInternational = state.settings.find(i => i.key === 'sales_order_default_shipping_method_international')

      if (selectedShippingMethodInternational) {
        const selected = getters.getShippingMethodsInternational.find(i => i.id === selectedShippingMethodInternational.value)
        return selected || null
      }

      return null
    },
    getSelectedShippingMethodDomestic: (state, getters) => {
      if (state.selectedShippingMethodDomestic) return state.selectedShippingMethodDomestic
      const selectedShippingMethodDomestic = state.settings.find(i => i.key === 'sales_order_default_shipping_method_domestic')

      if (selectedShippingMethodDomestic) {
        const selected = getters.getShippingMethodsDomestic.find(i => i.id === selectedShippingMethodDomestic.value)
        return selected || null
      }

      return null
    },
    getShippingMethodChanged: state => {
      const initialValue = (state.selectedItem && state.selectedItem?.shipping_method_id) || '-'
      const localValue = (state.selectedShippingMethod && state.selectedShippingMethod.id) || '-'
      return localValue !== initialValue
    },
    getSelectedShipBy: state => state.selectedShipBy,
    getShipByChanged: state => {
      const initialValue = (state.selectedItem?.ship_by_date && moment(state.selectedItem?.ship_by_date)) || '-'
      const localValue = (state.selectedShipBy && moment(state.selectedShipBy)) || '-'
      return localValue !== initialValue
    },
    getSelectedDeliverBy: state => state.selectedDeliverBy,
    getDeliverByChanged: state => {
      const initialValue = (state.selectedItem?.deliver_by_date && moment(state.selectedItem?.deliver_by_date).format('MM-DD-YY')) || '-'
      const localValue = (state.selectedDeliverBy && moment(state.selectedDeliverBy).format('MM-DD-YY')) || '-'
      return localValue !== initialValue
    },
    getSelectedCurrencyRate: state => state.selectedCurrencyRate,
    getCurrencyRateChanged: state => {
      const initialValue = state.selectedItem?.currency_rate || '-'
      const localValue = state.selectedCurrencyRate || '-'
      return localValue !== initialValue
    },
    getSelectedDiscounts: state => state.selectedDiscounts,
    getDiscountsChanged: state => {
      if (!state.selectedItem) return false

      const localItems = state.selectedDiscounts || []
      const initialItems = state.selectedItem?.discount_lines || []

      return wasArrayChanged(localItems, initialItems)
    },
    getSelectedTaxes: state => state.selectedTaxes,
    getTaxesChanged: state => {
      if (!state.selectedItem) return false

      const localItems = state.selectedTaxes || []
      const initialItems = state.selectedItem?.tax_lines || []

      return wasArrayChanged(localItems, initialItems)
    },
    getOrderTaxesChanged: state => {
      if (!state.selectedItem) return false

      return state.selectedTaxes.length ?
        state.selectedItem.tax_rate_id !== state.selectedTaxes[0].tax_rate_id:
        state.selectedItem.tax_rate_id !== null
    },
    getTagsChanged: state => {
      const localItems = state.selectedTags || []
      const initialItems = state.selectedItem?.tags || []

      return wasArrayChanged(localItems, initialItems)
    },
    getOrderProducts: state => state.orderProducts,
    getOrderProductsChanged: state => {
      return wasArrayChanged(state.orderProducts, state?.selectedItem?.item_info || [], state.itemFields)
    },
    getSomethingChanged (_,getters) {
      return getters.getStoreChanged || getters.getCustomerChanged || getters.getShippingAddressChanged ||
        getters.getBillingAddressChanged || getters.getCurrencyChanged || getters.getDateChanged ||
        getters.getShippingMethodChanged || getters.getShipByChanged || getters.getDeliverByChanged || getters.getDiscountsChanged ||
        getters.getOrderProductsChanged || getters.getRequestedShippingMethodChanged || getters.getTaxesChanged ||
        getters.getIsTaxIncludedChanged || getters.getOrderTaxesChanged || getters.getTagsChanged || getters.isOrderNumberChanged ||
        getters.getOrderFinancialLinesChanged || getters.isCustomFieldsChanged
    },
    getDrawerMode: state => state.drawerMode,
    getFetchedSelectValues: state => state.fetchedSelectValues,
    getSettingsList: state => state.settings,
    getSettingsLoading: state => state.settingsLoading,
    getSelectedNumberOfDigits: state => {
      if (state.selectedNumberOfDigits) return state.selectedNumberOfDigits
      let numOfDigits = state.settings.find(x => x.key === 'sales_order_num_of_digits')

      if (numOfDigits) {
        if (numOfDigits.value) {
          return { value: numOfDigits.value.toString() }
        }

        return { value: numOfDigits.default_value.toString() }
      }
    },
    getSelectedPrefix: state => {
      if (state.selectedPrefix) return state.selectedPrefix
      let prefix = state.settings.find(x => x.key === 'sales_order_prefix')

      if (prefix) {
        if (prefix.value) { return prefix.value }

        return prefix.default_value
      }
    },
    getSelectedStartNumber: state => {
      if (state.selectedStartNumber !== 1000) return state.selectedStartNumber
      let startNumber = state.settings.find(x => x.key === 'sales_order_start_number')

      if (startNumber) {
        if (startNumber.value) { return startNumber.value }

        return state.selectedStartNumber
      }
    },
    getDefaultHandlingDays: state => {
      if (state.selectedHandlingDays) return state.selectedHandlingDays
      let handlingDays = state.settings.find(x => x.key === 'sales_order_default_handling_days')

      if (handlingDays) {
        if (handlingDays.value) { return handlingDays.value }

        return state.selectedHandlingDays
      }
    },
    getSameDayShipping: state => {
      if (state.selectedSameDayShipping) return state.selectedSameDayShipping
      let SameDayShipping = state.settings.find(x => x.key === 'sales_order_same_day_shipping_cutoff')

      if (SameDayShipping) {
        if (SameDayShipping.value) { return SameDayShipping.value }

        return state.selectedSameDayShipping
      }
    },
    getSelectedShowTaxRate: state => {
      if (state.selectedShowTaxRate || state.selectedShowTaxRate === false || state.selectedShowTaxRate === 0) return state.selectedShowTaxRate
      let showRateObject = state.settings.find(x => x.key === 'sales_order_show_tax_rate')

      if (showRateObject) {
        if (showRateObject.value || showRateObject.value === 0) { return showRateObject.value }

        return state.selectedShowTaxRate
      }
    },
    getSelectedShowTaxAmount: state => {
      if (state.selectedShowTaxAmount || state.selectedShowTaxAmount === false || state.selectedShowTaxAmount === 0) return state.selectedShowTaxAmount
      let showAmountObject = state.settings.find(x => x.key === 'sales_order_show_tax_amount')

      if (showAmountObject) {
        if (showAmountObject.value || showAmountObject.value === 0) { return showAmountObject.value }

        return state.selectedShowTaxAmount
      }
    },
    getSelectedIsTaxIncluded: state => state.selectedIsTaxIncluded,
    getIsTaxIncludedChanged: (state, getters) => {
      if (!state.selectedItem) return false
      return state.selectedItem?.is_tax_included !== getters.getSelectedIsTaxIncluded
    },
    getDigits: state => state.num_of_digits,
    getShippingChangedForCreateMode: state => state.shippingChangedForCreateMode,
    getDefaultSettings: state => state.defaultSettings,
    getInventoryWarehouse: state => state.inventoryWarehouse,
    getOrderDrawer: state => state.orderDrawer,
    getSelectedOrderPayments: state => state.selectedItem?.payments || [],
    getInitialValuesAreSet: state => state.initialValuesAreSet,
    getShipByWasManuallySet: state => state.shipByWasManuallySet,
    getOrderAddProductDrawerMode: state => state.orderAddProductDrawerMode,
    getOrderAddProductDrawer: state => state.orderAddProductDrawer,
    getSkuCurrencies: state => state.skuCurrencies,
    getStarshiptFulfillment: state => state.starshiptFulfillment,
    getStarshiptOrderId: state => state.starshiptFulfillment?.order_id,
    getInstanceDetails: state => state.instanceDetails,
    getInstanceStoreUrl: state => state.instanceStoreUrl,
    getIsSetOrderTaxRate: (_, getters) => {
      if (!getters.getSelectedItem || !getters.getSelectedItem.hasOwnProperty('tax_rate_id')) return false
      return getters.getSelectedItem.tax_rate_id !== null
    },
    getIsSetItemsTaxRate: (_, getters) => {
      if (getters.getOrderProducts.length === 0) return false
      for (let product of getters.getOrderProducts) {
        if (product.tax_rate_id !== null) return true
      }
      return false
    },
    getSelectedTaxRate: state => state.selectedTaxRate,
    getSelectedItemAccounting: (_,getters) => getters.getSelectedItem.hasOwnProperty('accounting') ? getters.getSelectedItem.accounting : null,
    getOrderDiscount: state => state.orderDiscount,
    getSelectedTags: state => state.selectedTags,
    totalPaymentAmount: (_,getters) => {
      if (!getters.getSelectedOrderPayments) return 0
      return getters.getSelectedOrderPayments.reduce((acc,item) => {
        if (item.hasOwnProperty('amount')) acc += parseFloat(item.amount || 0)
        return acc
      },0)
    },
    totalSalesCredit: (_,getters) => {
      if (!getters.getSelectedItem?.sales_credits) return 0
      return getters.getSelectedItem.sales_credits.reduce((acc,item) => {
        acc += parseFloat(item.total)
        return acc
      },0)
    },
    totalDue: (_,getters) => {
      if (!getters.getSelectedItem) return 0
      return exactMath.round(parseFloat(getters.getOrderTotal) - (parseFloat(getters.totalPaymentAmount) + parseFloat(getters.totalSalesCredit)), -2)
    },
    getOrderTotal: (_,getters) => getters.getSelectedItem?.total || 0,
    getPOItemsIds: (_,getters) => {
      let ids = []
      if (getters.getSelectedItem?.purchase_orders && getters.getSelectedItem.purchase_orders.length) {
        ids = getters.getSelectedItem.purchase_orders.reduce((acc,item) => {
          if (item.item_info && Array.isArray(item.item_info)) acc = [...acc, ...item.item_info.map(i => i.item_sku.id)]
          return acc
        },[])
      }
      return new Set(ids)
    },
    getNotes: state => state.selectedItem?.notes || [],
    getCustomerRecentSO: state => state.selectedItem?.customer_recent_sales_orders || [],
    getCustomFields: state => state.customFields,
    getCustomFieldValues: state => state.customFieldValues,
    getUpdatedCustomFieldValues: state => state.updatedCustomFieldValues,
    getDisplayedCustomFields: state => state.displayedCustomFields,
    getInitialCustomFields: state => state.initialCustomFields,
    getSalesCredits: (_,getters) => getters.getSelectedItem?.sales_credits ?? [],
    getProductsByWarehouse: state => (warehouseId) => state.productsByWarehouse.get(warehouseId) || [],
    getFulfillmentsToCreate: state => state.fulfillments.toCreate,
    getFulfillmentsToSubmit: state => state.fulfillments.toSubmit,
    getFulfillmentsDifferences: state => state.fulfillments.differences,
    getFulfillmentsToCreateLines: state => state.fulfillments.toCreateLines,
    getIsLoadedFulfillments: state => state.isLoadedFulfillments,
    isFBA: (_,getters) => getters.getSelectedItem?.fulfillment_channel === 'AFN',
    getUnbundledProductsByWarehouse: (_,getters) => (warehouseId) => {
      const products = getters.getProductsByWarehouse(warehouseId)
      if (!products) return []
      return products.filter(p => [undefined, null].includes(p?.bundle))
    },
    getBundledProductsByWarehouse: (_, getters) => (warehouseId) => {
      const products = getters.getProductsByWarehouse(warehouseId)
      if (!products) return []

      const productsSet = products.reduce((acc, product) => {
        if (product?.bundle?.id) {
          // Use a composite key if sales_channel_line_id is not null, otherwise just use bundle.id
          const key = product.sales_channel_line_id
              ? `${product.sales_channel_line_id}-${product.bundle.id}`
              : product.bundle.id;
          let products = []

          if (acc.has(key)) products = [...acc.get(key), product]
          else products = [product]

          acc.set(key, products)
        }
        return acc
      }, new Map())

      return Array.from(productsSet.values())
    },
    getInventoryStartDateSetting: (_,getters) => {
      if(!getters.getGlobalSettings) return null
      const inventoryStartDate = getters.getGlobalSettings.find(({key}) => key === 'inventory_start_date')
      const {default_value = null, value = null} = inventoryStartDate

      let startDate = null
      if (checkIsDateString(value)) startDate = value.slice(0,10)
      else if (checkIsDateString(default_value)) startDate = default_value.slice(0,10)

      return startDate
    },
    getOrderNumber: (_, getters) => getters.getSelectedItem?.sales_order_number || '',
    getSelectedOrderNumber: state => state.selectedOrderNumber || '',
    getAutogenerateOrderNumber: state => state.autogenerateOrderNumber,
    isCreateDrawerMode: (_,getters) => getters.getDrawerMode === 'create',
    isEditDrawerMode: (_,getters) => getters.getDrawerMode === 'edit',
    isViewDrawerMode: (_,getters) => getters.getDrawerMode === 'view',
    isPaymentsDrawerMode: (_,getters) => getters.getDrawerMode === 'payments',
    isCostsDrawerMode: (_,getters) => getters.getDrawerMode === 'costs',
    isOrderNumberChanged: (_,getters) => getters.getSelectedOrderNumber !== getters.getOrderNumber,
    isCustomFieldsChanged: (_,getters) => {
      // if (!getters.getDisplayedCustomFields) return false

      if(getters.getInitialCustomFields !== getters.getDisplayedCustomFields) return true
      else return false

      // return wasArrayChanged(localItems, initialItems)
    },
    getSelectedUnpaidOrdersAsReservedSetting: (state,getters) => {
      const keyName = 'unpaid_orders_as_reserved'
      if(state.editedSettings.hasOwnProperty(keyName)) return state.editedSettings[keyName]
      const setting = getters.findSettingByKey(keyName)

      return Boolean(setting?.value)
    },
    getUnpaidOrdersAsReservedSettingChanged: (state,getters) => {
      const setting = getters.findSettingByKey('unpaid_orders_as_reserved')

      return Boolean(state.editedSettings?.unpaid_orders_as_reserved) !== Boolean(setting?.value)
    },
    findSettingByKey: state => keyName => state.settings.find(({key}) => key === keyName),
    getEditedSettings: state => state.editedSettings,
    isFetch: state => state.isFetch,
    // Financial Lines
    getFinancialLines: state => state.financialLines.map(line => ({...line, allocate_to_products: Boolean(line.allocate_to_products)})),
    getOrderFinancialLinesChanged: (state,getters) => {
      return wasArrayChanged(
        getters.getFinancialLines.map(l => ({...l,allocate_to_products: Number(l.allocate_to_products) })),
        state?.selectedItem?.financial_lines || [],
        state.financialLineFields
      ) || getters.getFinancialLines.length !== getters.getSelectedItem.financial_lines.length
    },
    getRevenueLines: (_,getters) => filterLinesByClassification(REVENUE,getters.getFinancialLines),
    getCostLines: (_,getters) => filterLinesByClassification(COST,getters.getFinancialLines),
    getRevenueTotal: (_,getters) => calculateLinesTotal(getters.getRevenueLines),
    getCostTotal: (_,getters) => calculateLinesTotal(getters.getCostLines),
    financialSpecificLines: (_,getters) => getters.getSelectedItem?.item_info.map(p => ({id: p.sales_order_line_id, text: `${p.item_quantity} x ${p.item_sku?.sku || ''}`, })) || [],
    getFinancialLinesFields: state => state.financialLineFields,
    isSkuIntegrationOrder: (_,getters) => getters.getSelectedItem?.integration ? getters.getSelectedItem.integration.toLowerCase() === 'sku.io' : false,
  },
  mutations: {
    SET_ITEMS_LIST (state, items) {
      state.itemsList = JSON.parse(JSON.stringify(items))
    },
    SET_SELECTED_NUMBER_OF_DIGITS (state, value) {
      state.selectedNumberOfDigits = value
    },
    SET_TABLE_SPECIFICATIONS (state, specs) {
      state.tableSpecifications = specs
    },
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_META (state, meta) {
      state.meta = meta
    },
    SET_ITEM_BY_ID_LOADING (state, value) {
      state.itemByIdLoading = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = JSON.parse(JSON.stringify(value))
    },
    SET_CUSTOMERS (state, value) {
      state.customers = value
    },
    UNSHIFT_NEW_CUSTOMER (state, value) {
      state.customers.unshift(value)
    },
    SET_CUSTOMERS_LOADING (state, value) {
      state.customersLoading = value
    },
    SET_CARRIERS (state, value) {
      state.carriers = value
    },
    SET_CARRIERS_LOADING (state, value) {
      state.carriersLoading = value
    },
    SET_SELECTED_STORE (state, value) {
      state.selectedStore = value
    },
    SET_SELECTED_CUSTOMER (state, value) {
      state.selectedCustomer = Object.assign({}, value)
    },
    SET_CUSTOMER_ADDRESSES (state, addresses) {
      Vue.prototype.$set(state.selectedCustomer, 'addresses', addresses)
    },
    SET_SELECTED_SHIPPING_ADDRESS (state, newAddress) {
      if (newAddress) {
        state.selectedShippingAddress = Object.assign({}, newAddress)
      } else {
        state.selectedShippingAddress = newAddress
      }
    },
    SET_SELECTED_BILLING_ADDRESS (state, newAddress) {
      if (newAddress) {
        state.selectedBillingAddress = Object.assign({}, newAddress)
      } else {
        state.selectedBillingAddress = newAddress
      }
    },
    SET_ADDRESS_FOR_CUSTOMER (state, newCustomer) {
      const shippingAddress = newCustomer.addresses.find(address => address.is_default_shipping)
      state.selectedShippingAddress = shippingAddress || null

      const billingAddress = newCustomer.addresses.find(address => address.is_default_billing)

      if (billingAddress) {
        state.selectedBillingAddress = billingAddress
      } else {
        state.selectedBillingAddress = shippingAddress || null
      }
    },
    SET_SELECTED_CURRENCY (state, value) {
      state.selectedCurrency = value
    },
    SET_SELECTED_DATE (state, value) {
      state.selectedDate = value
    },
    SET_SELECTED_SHIPPING_METHOD (state, value) {
      state.selectedShippingMethod = value
    },
    SET_SELECTED_REQUESTED_SHIPPING_METHOD (state, value) {
      state.selectedRequestedShippingMethod = value
    },
    SET_SELECTED_SHIPPING_METHOD_INTERNATIONAL (state, value) {
      state.selectedShippingMethodInternational = value
    },
    SET_SELECTED_SHIPPING_METHOD_DOMESTIC (state, value) {
      state.selectedShippingMethodDomestic = value
    },
    SET_SELECTED_SHIP_BY (state, value) {
      state.selectedShipBy = value
    },
    SET_SELECTED_DELIVER_BY (state, value) {
      state.selectedDeliverBy = value
    },
    SET_SELECTED_CURRENCY_RATE (state, value) {
      state.selectedCurrencyRate = value
    },
    SET_SELECTED_DISCOUNTS (state, value) {
      state.selectedDiscounts = value
    },
    REMOVE_DISCOUNT_BY_INDEX (state, index) {
      state.selectedDiscounts.splice(index, 1)
    },
    EDIT_DISCOUNT_BY_INDEX (state, { index, value }) {
      Vue.prototype.$set(state.selectedDiscounts, index, value)
    },
    SET_SELECTED_TAXES (state, value) {
      state.selectedTaxes = value
    },
    REMOVE_TAX_BY_INDEX (state, index) {
      state.selectedTaxes.splice(index, 1)
    },
    EDIT_TAX_BY_INDEX (state, { index, value }) {
      Vue.prototype.$set(state.selectedTaxes, index, value)
    },
    SET_ORDER_PRODUCTS (state, value) {
      state.orderProducts = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_FETCHED_SELECT_VALUES (state, value) {
      state.fetchedSelectValues = value
    },
    SET_SETTINGS (state, value) {
      state.settings = value
    },
    SET_SETTINGS_LOADING (state, value) {
      state.settingsLoading = value
    },
    SET_SELECTED_PREFIX (state, value) {
      state.selectedPrefix = value
    },
    SET_START_NUMBER (state, value) {
      state.selectedStartNumber = value
    },
    SET_DEFAULT_HANDLING_DAYS (state, value) {
      state.selectedHandlingDays = value
    },
    SET_SAME_DAY_SHIPPING (state, value) {
      state.selectedSameDayShipping = value
    },
    SET_SELECTED_SHOW_TAX_RATE (state, value) {
      state.selectedShowTaxRate = value
    },
    SET_SELECTED_SHOW_TAX_AMOUNT (state, value) {
      state.selectedShowTaxAmount = value
    },
    SET_SHIPPING_CHANGED_FOR_CREATE_MODE (state, value) {
      state.shippingChangedForCreateMode = value
    },
    SET_DEFAULT_SETTING_FIELD (state, { value, field }) {
      Vue.prototype.$set(state.defaultSettings, field, value)
    },
    SET_INVENTORY_WAREHOUSE (state, { value, field }) {
      Vue.prototype.$set(state.inventoryWarehouse, field, value)
    },
    SET_ORDER_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.orderDrawer, field, value)
    },
    SET_SELECTED_ORDER_PAYMENTS (state, payments) {
      state.selectedOrderPayments = payments
    },
    SET_INITIAL_VALUES_ARE_SET (state, value) {
      state.initialValuesAreSet = value
    },
    SET_CUSTOM_FIELDS (state, value) {
      state.customFields = value
    },
    SET_CUSTOM_FIELD_VALUES (state, value) {
      state.customFieldValues = value
    },
    SET_UPDATED_CUSTOM_FIELD_VALUES (state, value) {
      state.updatedCustomFieldValues = value
    },
    SET_DISPLAYED_CUSTOM_FIELDS(state, fields) {
      state.displayedCustomFields = fields;
    },
    SET_INITIAL_CUSTOM_FIELDS(state, fields) {
      state.initialCustomFields = fields;
    },
    SET_SALES_CREDIT_MODAL_FIELD(state, { field, value }) {
      Vue.prototype.$set(state.salesCreditModal, field, value)
    },
    SET_PAYMENT_MODAL_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.paymentModal, field, value)
    },
    SET_CUSTOM_FIELD_MODAL (state, { field, value }) {
      Vue.prototype.$set(state.customFieldModal, field, value)
    },
    SET_CUSTOM_FIELDS_MANAGE_MODAL (state, { field, value }) {
      Vue.prototype.$set(state.customFieldsManageModal, field, value)
    },
    SET_PAYMENTS_LOADING (state, value) {
      state.paymentsLoading = value
    },
    SET_SHIP_BY_WAS_MANUALLY_SET (state, value) {
      state.shipByWasManuallySet = value
    },
    SET_ORDER_ADD_PRODUCT_DRAWER_FIELD (state, { value, field }) {
      Vue.prototype.$set(state.orderAddProductDrawer, field, value)
    },
    SET_ORDER_ADD_PRODUCT_DRAWER_MODE (state, value) {
      state.orderAddProductDrawerMode = value
    },
    SET_GLOBAL_SETTINGS (state, value) {
      state.globalSettings = value
    },
    SET_SKU_CURRENCIES (state, value) {
      state.skuCurrencies = value
    },
    SET_INSTANCE_DETAILS (state, value) {
      state.instanceDetails = value
    },
    SET_ITEMS_LOADING (state, value) {
      state.itemsLoading = value
    },
    SET_STARSHIPT_FULFILLMENT (state, value) {
      state.starshiptFulfillment = value
    },
    SET_INSTANCE_STORE_URL (state, value) {
      state.instanceStoreUrl = value
    },
    SET_SELECTED_IS_TAX_INCLUDED (state, value) {
      state.selectedIsTaxIncluded = value
    },
    SET_SELECTED_ORDER_TAX_RATE (state, value) {
      state.selectedTaxRate = value
    },
    SET_SELECTED_TAGS (state, value) {
      state.selectedTags = value
    },
    SET_PRODUCTS_BY_WAREHOUSE (state, value) {
      state.productsByWarehouse = value
    },
    SET_FULFILLMENTS_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.fulfillments, field, value)
    },
    SET_FULFILLMENTS_TO_CREATE_LINES (state, value) {
      const toCreateLines = value.reduce((acc, fulfillment) => {
        acc = [...acc, ...fulfillment.fulfillment_lines]
        return acc
      },[])
      Vue.prototype.$set(state.fulfillments, 'toCreateLines', toCreateLines)
    },
    SET_LOADED_FULFILLMENTS (state, value) {
      state.isLoadedFulfillments = value
    },
    SET_SELECTED_ORDER_NUMBER (state, value) {
      state.selectedOrderNumber = value
    },
    SET_AUTOGENERATE_ORDER_NUMBER (state, value) {
      state.autogenerateOrderNumber = value
    },
    SET_EDITED_SETTING_FIELD (state, {field,value}) {
      Vue.prototype.$set(state.editedSettings, field, value)
    },
    SET_EDITED_SETTINGS (state, value) {
      Vue.prototype.$set(state, 'editedSettings', value)
    },
    RESET_EDITED_SETTINGS (state, values) {
      const settings = values.reduce((acc,{key,value}) => {
        acc = {...acc, [key]:value }
        return acc
      },{})
      Vue.prototype.$set(state, 'editedSettings', settings)
    },
    SET_IS_FETCH (state,value) {
      state.isFetch = value
    },
    SET_FINANCIAL_LINES (state, value) {
      state.financialLines = value
    },
    SET_INITIAL_FINANCIAL_LINES (state, value) {
      state.initialFinancialLines = value
    },
  },
  actions: {
    async getItemsRequest ({ commit, state }, query) {

      try {
        commit('SET_ITEMS_LOADING', true)
        const response = await getAllSalesOrders(query)

        if (response?.data) commit('SET_ITEMS_LIST', response.data)
        if (response?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
        //console.log(response?.data, query)
      } catch (e) {
        //console.log(e)
        throw e
      } finally {
        commit('SET_ITEMS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllSalesOrders(query)
        if (response?.meta?.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response?.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllSalesOrders(query)

        if (response?.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchLookupValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupOrdersValues({ value, header, page, limit })
      } catch (e) {
      }
    },
    async fetchAllCustomers ({ commit }, query) {
      try {
        commit('SET_CUSTOMERS_LOADING', true)
        const response = await getAllCustomers(query)
        if (response?.data) commit('SET_CUSTOMERS', response.data)
      } catch (e) {
      } finally {
        commit('SET_CUSTOMERS_LOADING', false)
      }
    },
    async fetchAllCarriers ({ commit }) {
      try {
        commit('SET_CARRIERS_LOADING', true)
        const response = await getAllShippingCarriers()
        if (response?.data) commit('SET_CARRIERS', response.data)
      } catch (e) {
      } finally {
        commit('SET_CARRIERS_LOADING', false)
      }
    },
    async fetchSettings ({ commit }) {
      try {
        commit('SET_SETTINGS_LOADING', true)
        const {data} = await settingsSalesOrders()
        if (!data) return
        commit('SET_SETTINGS', data)
        commit('RESET_EDITED_SETTINGS', data)
      } catch (e) {
      } finally {
        commit('SET_SETTINGS_LOADING', false)
      }
    },
    async addPaymentToSelectedOrder ({ state, commit, rootState }, payload) {
      if (!state.selectedItem) return
      try {
        const {data} = await addPayment(state.selectedItem.id, payload)
        let payment = getPaymentObject(data)
        const paymentType = rootState.PaymentTypesModule.types.find(type => type.id === data.payment_type_id)
        if (paymentType && paymentType.name) payment.payment_type.name = paymentType.name
        // Add payment to payments
        const payments = cloneDeep(state.selectedOrderPayments)
        payments.unshift(payment)
        commit('SET_SELECTED_ORDER_PAYMENTS', payments)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async fetchSelectedPayments ({ state, commit }) {
      if (!state.selectedItem?.id) return
      try {
        commit('SET_PAYMENTS_LOADING', true)
        commit('SET_SELECTED_ORDER_PAYMENTS', (await getPayments(state.selectedItem.id)).data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_PAYMENTS_LOADING', false)
      }
    },
    async fetchStarshiptFulfillment ({ commit }, payload) {
      try {
        const { data } = await fetchOrderStarshipitFulfillment(payload)
        commit('SET_STARSHIPT_FULFILLMENT', data)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async updateSelectedCreditPayment ({state,commit,getters}, payload) {
      if (!state.selectedItem) return
      try {
        const {data} = await updatePayment(state.selectedItem.id, payload.id, payload.payment)
        let paymentData = getPaymentObject(data, data.payment_type)
        const payments = cloneDeep(getters.getSelectedOrderPayments)
          .map(payment => {
            if (payment.id === data.id) {
              payment.amount = data.amount
              payment.payment_date = data.payment_date
              payment.payment_type = paymentData.payment_type
              payment.payment_type_id = data.payment_type_id
              payment.external_reference = data.external_reference
            }
            return payment
          })
        // Add payment to payments
        commit('SET_PAYMENT_MODAL_FIELD', {field: 'payment', value: null})
        commit('SET_SELECTED_ORDER_PAYMENTS', payments)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async compareFulfillmentsWithSalesChannel ({commit, getters}, payload) {
      try {
        commit('SET_LOADED_FULFILLMENTS', true)
        const {data} = await compareFulfillmentsWithSalesChannel(payload)
        commit('SET_FULFILLMENTS_FIELD', {field: 'toCreate', value: data?.fulfillmentToCreate || []})
        commit('SET_FULFILLMENTS_FIELD', {field: 'toSubmit', value: data?.fulfillmentsToSubmit || []})
        commit('SET_FULFILLMENTS_FIELD', {field: 'differences', value: data?.differences || []})
        commit('SET_FULFILLMENTS_TO_CREATE_LINES', data?.fulfillmentToCreate || [])
      } catch (e) {
        return Promise.reject(e)
      }
    },
  }
}
