import { getAllInventoryMovements } from '@/services/InventoryMovementService'
import Vue from 'vue'

export const InventoryMovementModule = {
  namespaced: true,
  state: {
    inventoryMovement: {
      itemsList: [],
      tableSpecifications: {},
      maxPages: 0,
      meta: {},
      loading: false
    }
  },
  getters: {
    getInventoryMovementItemsList: state => state.inventoryMovement.itemsList,
    getInventoryMovementTableSpecifications: state => state.inventoryMovement.tableSpecifications,
    getInventoryMovementMaxPages: state => state.inventoryMovement.maxPages,
    getInventoryMovementMeta: state => state.inventoryMovement.meta,
    getInventoryMovementLoading: state => state.inventoryMovement.loading
  },
  mutations: {
    SET_INVENTORY_MOVEMENT_ITEMS_LIST (state, value) {
      Vue.prototype.$set(state.inventoryMovement, 'itemsList', value)
    },
    SET_INVENTORY_MOVEMENT_TABLE_SPECIFICATIONS (state, value) {
      Vue.prototype.$set(state.inventoryMovement, 'tableSpecifications', value)
    },
    SET_INVENTORY_MOVEMENT_MAX_PAGES (state, value) {
      Vue.prototype.$set(state.inventoryMovement, 'maxPages', value)
    },
    SET_INVENTORY_MOVEMENT_META (state, value) {
      Vue.prototype.$set(state.inventoryMovement, 'meta', value)
    },
    SET_INVENTORY_MOVEMENT_LOADING (state, value) {
      Vue.prototype.$set(state.inventoryMovement, 'loading', value)
    }
  },
  actions: {
    // inventory movement requests
    async getInventoryMovementItemsRequest ({ commit }, query) {
      try {
        commit('SET_INVENTORY_MOVEMENT_LOADING', true)
        const response = await getAllInventoryMovements(query)
        commit('SET_INVENTORY_MOVEMENT_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_INVENTORY_MOVEMENT_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_INVENTORY_MOVEMENT_LOADING', false)
      }
    },
    async getInventoryMovementMetaRequest ({ commit, state }, query) {
      try {
        const response = await getAllInventoryMovements(query)
        if (response.meta && response.meta.last_page) commit('SET_INVENTORY_MOVEMENT_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_INVENTORY_MOVEMENT_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllInventoryMovements(query)

        if (response.data?.table_specifications) commit('SET_INVENTORY_MOVEMENT_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    }
  }
}
