import { getInventoryAdjustments } from '@/services/InventoryAdjustmentsService'
import Vue from 'vue'
import { isEqual } from 'lodash'

export const InventoryAdjustmentsModule = {
  namespaced: true,
  state: {
    inventoryAdjustments: {
      itemsList: [],
      tableSpecifications: {},
      maxPages: 0,
      meta: {},
      loading: false
    },

    drawerMode: null,
    selectedItem: null,
    itemByIdLoading: false,

    editedItem: {
      warehouse: null,
      date: '',
      type: '',
      quantity: '',
      unitCost: '',
      notes: ''
    },
    initialItem: null,

    inventoryAdjustmentDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false,
      ignoreItemResetOnLaunch: false
    },

  },
  getters: {
    getItemsList: state => state.inventoryAdjustments.itemsList,
    getTableSpecifications: state => state.inventoryAdjustments.tableSpecifications,
    getMaxPages: state => state.inventoryAdjustments.maxPages,
    getMeta: state => state.inventoryAdjustments.meta,
    getDrawerMode: state => state.drawerMode,
    getSomethingChanged: (state) => {
      return !isEqual(state.initialItem, state.editedItem)
    },
    getSelectedItem: state => state.selectedItem,
    getSelectedItemIndex: state => {
      if (!state.selectedItem) return 0
      const index = state.inventoryAdjustments.itemsList.findIndex(i => i.id === state.selectedItem.id)
      return index
    },
    getItemByIdLoading: state => state.itemByIdLoading,
    getEditedItem: state => state.editedItem,
    getInventoryAdjustmentDrawer: state => state.inventoryAdjustmentDrawer,
    getLoading: state => state.inventoryAdjustments.loading,
  },
  mutations: {
    SET_INVENTORY_ADJUSTMENTS_ITEMS_LIST (state, value) {
      Vue.prototype.$set(state.inventoryAdjustments, 'itemsList', value)
    },
    SET_INVENTORY_ADJUSTMENTS_TABLE_SPECIFICATIONS (state, value) {
      Vue.prototype.$set(state.inventoryAdjustments, 'tableSpecifications', value)
    },
    SET_INVENTORY_ADJUSTMENTS_MAX_PAGES (state, value) {
      Vue.prototype.$set(state.inventoryAdjustments, 'maxPages', value)
    },
    SET_INVENTORY_ADJUSTMENTS_META (state, value) {
      Vue.prototype.$set(state.inventoryAdjustments, 'meta', value)
    },
    SET_INVENTORY_ADJUSTMENTS_LOADING (state, value) {
      Vue.prototype.$set(state.inventoryAdjustments, 'loading', value)
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_EDITED_ITEM (state, value) {
      state.editedItem = value
    },
    SET_EDITED_ITEM_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedItem, field, value)
    },
    SET_INITIAL_ITEM (state, value) {
      state.initialItem = value
    },
    SET_ITEM_BY_ID_LOADING (state, value) {
      state.itemByIdLoading = value
    },
    SET_INVENTORY_ADJUSTMENT_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.inventoryAdjustmentDrawer, field, value)
    },
  },
  actions: {
    // inventory adjustments requests
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_INVENTORY_ADJUSTMENTS_LOADING', true)
        const response = await getInventoryAdjustments(query)

        commit('SET_INVENTORY_ADJUSTMENTS_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_INVENTORY_ADJUSTMENTS_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_INVENTORY_ADJUSTMENTS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit, state }, query) {
      try {
        const response = await getInventoryAdjustments(query)
        if (response.meta && response.meta.last_page) commit('SET_INVENTORY_ADJUSTMENTS_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_INVENTORY_ADJUSTMENTS_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getInventoryAdjustments(query)

        if (response.data?.table_specifications) commit('SET_INVENTORY_ADJUSTMENTS_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
  }
}
