
import {
  getMagentoStores,
  getMagentoMappings,
  deleteMagentoMapping,
  mapMagentoStores,
  downloadMagentoStores
} from '@/services/IntegrationsService'
import { getAllStores } from '@/services/StoresService'

export const IntegrationStoreModule = {
  namespaced: true,
  state: {
    unmappedMethods: [],
    skuStores: [],
    magentoStores: [],
    loading: false,
    lookupLoading: false,
    magentoMappings: [],
    listingsLoading: false
  },
  getters: {
    getLookupLoading: state => state.lookupLoading,
    getUnmappedMethods: state => state.unmappedMethods,
    getSkuStores: state => state.skuStores,
    getMagentoStores: state => state.magentoStores,
    getMagentoMappings: state => state.magentoMappings,
    getListingsLoading: state => state.listingsLoading
  },
  mutations: {
    SET_UNMAPPED_METHODS (state, value) {
      state.unmappedMethods = value
    },
    SET_INTEGRATION_LOADING (state, value) {
      state.loading = value
    },
    SET_LOOKUP_LOADING (state, value) {
      state.lookupLoading = value
    },
    SET_SKU_STORES (state, value) {
      state.skuStores = value
    },
    SET_MAGENTO_STORES (state, value) {
      state.magentoStores = value
    },
    SET_MAGENTO_MAPPINGS (state, value) {
      state.magentoMappings = value
    },
    SET_LISTINGS_LOADING (state, value) {
      state.listingsLoading = value
    }
  },
  actions: {
    async fetchSKUStores ({ commit }) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const response = await getAllStores()
        if (response?.data) commit('SET_SKU_STORES', response.data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async fetchMagentoStores ({ commit }, instanceId) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const response = await getMagentoStores(instanceId)
        if (response?.data) commit('SET_MAGENTO_STORES', response.data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async fetchStoreMappings ({ commit }, instanceId) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const response = await getMagentoMappings(instanceId)
        if (response?.data) commit('SET_MAGENTO_MAPPINGS', response.data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async deleteMapping ({ commit, dispatch }, payload) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { message } = await deleteMagentoMapping(payload)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async mapPaymentMethod ({ commit, dispatch }, { instanceId, sendData }) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { status, message } = await mapMagentoStores(instanceId, sendData)
        if (status === 'success') dispatch('fetchStoreMappings', instanceId)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async downloadMagentoListings ({ commit, dispatch }, instanceId) {
      commit('SET_LISTINGS_LOADING', true)
      try {
        const { message } = await downloadMagentoStores(instanceId)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LISTINGS_LOADING', false)
      }
    }
  }
}
