import {
  mapSalesChannelPaymentMethods,
  fetchSalesChannelPaymentMethods,
  lookupSalesChannelPaymentMethods,
  deleteSalesChannelPaymentMethodMapping
  , deleteSalesChannelShippingMethodMapping, deleteShippingProviderShippingMethod } from '@/services/IntegrationsService'
import { getPaymentTypes } from '@/services/PaymentTypesService'

export const IntegrationPaymentModule = {
  namespaced: true,
  state: {
    integrationPayments: [],
    unmappedMethods: [],
    skuPaymentTypes: [],
    loading: false,
    lookupLoading: false
  },
  getters: {
    getIntegrationPaymentMethods: state => state.integrationPayments.sort((a, b) => a.id > b.id ? -1 : 1),
    getSkuPaymentTypes: state => state.skuPaymentTypes,
    getLookupLoading: state => state.lookupLoading,
    getUnmappedMethods: state => state.unmappedMethods
  },
  mutations: {
    SET_UNMAPPED_METHODS (state, value) {
      state.unmappedMethods = value
    },
    SET_INTEGRATION_PAYMENTS (state, value) {
      state.integrationPayments = value
    },
    SET_INTEGRATION_LOADING (state, value) {
      state.loading = value
    },
    SET_LOOKUP_LOADING (state, value) {
      state.lookupLoading = value
    },
    SET_INTEGRATION_PAYMENT_TYPES (state, value) {
      state.skuPaymentTypes = value
    }
  },
  actions: {
    async fetchPaymentMethods ({ commit }, payload) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const response = await fetchSalesChannelPaymentMethods(payload)
        if (response?.data) {
          commit('SET_INTEGRATION_PAYMENTS', response.data)
        }
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async fetchPaymentTypes ({ commit }) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const response = await getPaymentTypes()
        if (response?.data) commit('SET_INTEGRATION_PAYMENT_TYPES', response.data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async deleteMapping ({ commit, dispatch }, payload) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { message } = await deleteSalesChannelPaymentMethodMapping(payload)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async deleteShippingMapping ({ commit, dispatch }, payload) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { message } = await deleteSalesChannelShippingMethodMapping(payload)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async deleteShippingProviderMapping ({ commit, dispatch }, payload) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { message } = await deleteShippingProviderShippingMethod(payload)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async deleteTaxMapping ({ commit, dispatch }, payload) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { message } = await deleteTaxRateMapping(payload)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    },
    async lookupUnmappedMethods ({ commit }, payload) {
      commit('SET_LOOKUP_LOADING', true)
      const params = payload?.value ? { value: payload.value } : {}
      try {
        const response = await lookupSalesChannelPaymentMethods(payload.channelId, params)
        if (response?.data) commit('SET_UNMAPPED_METHODS', response.data.map(method => ({ value: method })))
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOOKUP_LOADING', false)
      }
    },
    async mapPaymentMethod ({ commit, dispatch }, { channelId, sendData }) {
      commit('SET_INTEGRATION_LOADING', true)
      try {
        const { status, message } = await mapSalesChannelPaymentMethods(channelId, sendData)
        if (status === 'success') dispatch('fetchPaymentMethods', channelId)
        return Promise.resolve(message)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_INTEGRATION_LOADING', false)
      }
    }
  }
}
