import { fetchFifoLayers, getFifoLayerById } from '@/services/FifoLayersService'
import Vue from 'vue'

export const FifoLayersModule = {
  namespaced: true,
  state: {
    fifoLayers: {
      itemsList: [],
      tableSpecifications: {},
      maxPages: 0,
      meta: {},
      loading: false
    },
    selectedItem: {},
    drawerMode: 'view',
    fifoLayerDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },
    fifoLayerLoading: false
  },
  getters: {
    getItemsList: state => state.fifoLayers.itemsList,
    getTableSpecifications: state => state.fifoLayers.tableSpecifications,
    getMaxPages: state => state.fifoLayers.maxPages,
    getMeta: state => state.fifoLayers.meta,
    getSelectedItem: state => state.selectedItem,
    getSelectedItemIndex: state => {
      if (!state.selectedItem || !state.fifoLayers.itemsList.length) { return -1 }
      return state.fifoLayers.itemsList.findIndex(i => i.id === state.selectedItem.id)
    },
    getDrawerMode: state => state.drawerMode,
    getFifoLayerDrawer: state => state.fifoLayerDrawer,
    getFifoLayerLoading: state => state.fifoLayerLoading,
    getLoading: state => state.fifoLayers.loading
  },
  mutations: {
    SET_FIFO_LAYERS_ITEMS_LIST (state, value) {
      Vue.prototype.$set(state.fifoLayers, 'itemsList', value)
    },
    SET_FIFO_LAYERS_TABLE_SPECIFICATIONS (state, value) {
      Vue.prototype.$set(state.fifoLayers, 'tableSpecifications', value)
    },
    SET_FIFO_LAYERS_MAX_PAGES (state, value) {
      Vue.prototype.$set(state.fifoLayers, 'maxPages', value)
    },
    SET_FIFO_LAYERS_META (state, value) {
      Vue.prototype.$set(state.fifoLayers, 'meta', value)
    },
    SET_FIFO_LAYERS_LOADING (state, value) {
      Vue.prototype.$set(state.fifoLayers, 'loading', value)
    },
    SET_SELECTED_FIFO_LAYER (state, fifoLayer) {
      state.selectedItem = fifoLayer
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_FIFO_LAYER_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.fifoLayerDrawer, field, value)
    },
    SET_FIFO_LAYER_LOADING (state, loading) {
      state.fifoLayerLoading = loading
    }
  },
  actions: {
    // inventory adjustments requests
    async setSelectedFifoLayer ({ commit }, ID) {
      try {
        if (ID === null) {
          commit('SET_SELECTED_FIFO_LAYER', null)
          return
        }
        commit('SET_FIFO_LAYER_LOADING', true)
        const {data} = await getFifoLayerById(ID)
  
        commit('SET_SELECTED_FIFO_LAYER', data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_FIFO_LAYER_LOADING', false)
      }
    },
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_FIFO_LAYERS_LOADING', true)
        const response = await fetchFifoLayers(query)

        commit('SET_FIFO_LAYERS_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_FIFO_LAYERS_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_FIFO_LAYERS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit, state }, query) {
      try {
        const response = await fetchFifoLayers(query)
        if (response.meta && response.meta.last_page) commit('SET_FIFO_LAYERS_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_FIFO_LAYERS_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await fetchFifoLayers(query)

        if (response.data?.table_specifications) commit('SET_FIFO_LAYERS_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
  }
}
