import { getTableMetaRequest, getTableSpecificationsRequest, getItemsRequest } from '@/support/tableApiRequestHelpers'
import { getDailyFinanacialSummary } from '@/services/FinancialsService'
import Vue from 'vue'

export const DailyFinancialSummaryModule = {
  namespaced: true,
  state: {
    itemsList: [],
    mappings: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,

    selectedItem: null,
    drawerMode: null,
    reportDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    }
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,

    getSelectedItem: state => state.selectedItem,
    getSelectedItemIndex: state => {
      if (!state.selectedItem) return 0
      const index = state.itemsList.findIndex(i => i.id === state.selectedItem.id)
      return index
    },
    getDrawerMode: state => state.drawerMode,
    getReportDrawer: state => state.reportDrawer
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },

    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_REPORT_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.reportDrawer, field, value)
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      return getItemsRequest(query, commit, getDailyFinanacialSummary)
    },
    async getMetaRequest ({ commit }, query) {
      return getTableMetaRequest(query, commit, getDailyFinanacialSummary)
    },
    async loadTableSpecifications ({ commit }, query) {
      return getTableSpecificationsRequest(query, commit, getDailyFinanacialSummary)
    },
  }
}
