import Vue from 'vue'
import { fetchCompanyProfile, updateCompanyProfile } from '@/services/CompanyProfileService'
import { isEqual } from 'lodash'

export const CompanyProfileModule = {
  namespaced: true,
  state: {
    basicInformation: {
      name: null,
      email: null,
      phone: null,
      is_billing: false,
      address: {
        address1: '',
        address2: '',
        address3: '',
        province: '',
        province_code: '',
        city: '',
        zip: '',
        country: '',
        country_code: ''
      }
    },
    initialBasicInformation: null
  },
  getters: {
    getBasicInformation: state => state.basicInformation,
    getBasicInformationChanged: state => {
      return !isEqual(state.basicInformation, state.initialBasicInformation)
    }
  },
  mutations: {
    SET_BASIC_INFORMATION_FIELD (state, {field, value}) {
      Vue.prototype.$set(state.basicInformation, field, value)
    },
    SET_INITIAL_BASIC_INFORMATION (state, value) {
      state.initialBasicInformation = JSON.parse(JSON.stringify(value))
    },
    SET_BASIC_INFORMATION_ADDRESS (state, value) {
      for (const field in value) {
        if (state.basicInformation.hasOwnProperty(field)) {
          Vue.prototype.$set(state.basicInformation, field, value[field])
        } else if (state.basicInformation.address.hasOwnProperty(field)) {
          Vue.prototype.$set(state.basicInformation.address, field, value[field])
        }
        if (field === 'state_province') Vue.prototype.$set(state.basicInformation.address, 'province', value[field])
        if (field === 'address_lines') {
          const addressLength = value[field].length
          for (let i = 0; i < addressLength; i++) {
            Vue.prototype.$set(state.basicInformation.address, `address${i+1}`, value[field][i])
          }
          if (addressLength !== 3) {
            for (let i = 3; i > addressLength; i--) {
              Vue.prototype.$set(state.basicInformation.address, `address${i}`, '')
            }
          }
        }
      }

    }
  },
  actions: {
    async fetchCompanyProfile ({commit, getters}) {
      try {
        const { data } = await fetchCompanyProfile()
        commit('SET_BASIC_INFORMATION_ADDRESS', data)
        commit('SET_INITIAL_BASIC_INFORMATION', getters.getBasicInformation)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async updateCompanyProfile ({commit, getters}, payload) {
      try {
        const { data, message } = await updateCompanyProfile(payload)
        commit('SET_BASIC_INFORMATION_ADDRESS', data)
        commit('SET_INITIAL_BASIC_INFORMATION', getters.getBasicInformation)
        return message
      } catch (e) {
        return Promise.reject(e)
      }
    }
  }
}
