import { getAttributes } from '@/services/AttributesService'

export const AttributesModule = {
  namespaced: true,
  state: {
    attributes: {
      grouped: [],
      ungrouped: []
    }
  },
  getters: {
    getGrouped: state => state.attributes.grouped,
    getDirect: state => state.attributes.ungrouped
  },
  mutations: {
    SET_ATTRIBUTES (state, value) {
      state.attributes = value
    },
    PUSH_TO_GROUPED (state, value) {
      state.attributes.grouped.push(value)
    }
  },
  actions: {
    async initialize ({ commit }) {
      // We only fetch attributes once.
      const attributes = await getAttributes()
      commit('SET_ATTRIBUTES', attributes)
      return attributes
    }
  }
}
