import Vue from 'vue'

export const ActivityLogModule = {
  namespaced: true,
  state: {
    activityLogDrawer: {
      show: false,
      hideNavigator: false,
      initialItem: null,
      initialItemId: null
    },
    entity: {
      item: null,
      fqn: null
    },
    drawerMode: 'null'
  },
  getters: {
    getActivityLogDrawer: state => state.activityLogDrawer,
    // These 3 are required for drawers
    getSelectedItem: state => state.entity.item,
    getDrawerMode: state => state.drawerMode,
    getEntity: state => state.entity
  },
  mutations: {
    // These 3 are required for drawers
    SET_ACTIVITY_LOG_DRAWER_FIELD (state, { value, field }) {
      Vue.prototype.$set(state.activityLogDrawer, field, value)
    },
    SET_ENTITY (state, value) {
      state.entity = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_SELECTED_ACTIVITY_LOG(state, value) {
      state.entity.item = value;
    }
  }
}
