import { fetchActivityLog } from '@/services/ActivityLogService'

export const ActivitiesModule = {
  namespaced: true,
  state: {
    loading: false,
    itemsList: [],
  },
  getters: {
    getActivities: state => state.itemsList,
    getLoadingActivities: state => state.loading,
    getSortedActivities: state => state.itemsList.slice().sort((a,b) => a.created_at < b.created_at ? 1 : -1)
  },
  mutations: {
    SET_ACTIVITIES (state, value) {
      state.itemsList = value
    },
    SET_ACTIVITIES_LOADING (state, value) {
      state.loading = value
    },
  },
  actions: {
    async fetchActivity ({commit}, params) {
      try {
        commit('SET_ACTIVITIES_LOADING', true)
        const data = await fetchActivityLog(params)
        commit('SET_ACTIVITIES', data || [])
      } catch (e) {
        throw e
      } finally {
        commit('SET_ACTIVITIES_LOADING', false)
      }
    }
  }
}
