import { fetchPayments } from '@/services/AccountingService'
import { lookupAccountingPayments } from '@/services/LookupService'
import { getTableMetaRequest, getTableSpecificationsRequest, getItemsRequest } from '@/support/tableApiRequestHelpers'
import moment from 'moment-timezone'

export const AccountingPaymentsModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false
  },
  getters: {
    getItemsList: (state,_, rootState) => {
      const startDate = rootState?.AccountingModule?.integration?.integration_settings?.settings?.sync_start_date ?? null
      let isDisabled = false
      
      return state.itemsList.map(item => {
        if (startDate && item.payment_date) isDisabled = moment(item.payment_date).isBefore(startDate)
        if (!Boolean(item?.type?.name)) isDisabled = true
        item.is_disabled_checkbox = isDisabled
        return item
      })
    },
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    isLinkableHeader: (state) => (value) => {
      return ['type', 'parent_type'].includes(value)
    }
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      return getItemsRequest(query, commit, fetchPayments)
    },
    async getMetaRequest ({ commit }, query) {
      return getTableMetaRequest(query, commit, fetchPayments)
    },
    async loadTableSpecifications ({ commit }, query) {
      return getTableSpecificationsRequest(query, commit, fetchPayments)
    },
    async fetchLookupValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupAccountingPayments({ value, header, page, limit })
      } catch (e) {

      }
    }
  }
}
