import {postAxiosRequest, getAxiosRequest, putAxiosRequest, deleteAxiosRequest} from '@/support/apiRequestHelpers'

const baseUrl = '/woo-commerce'

const getUrl = (path = '') => (path ? `${baseUrl}/${path}` : baseUrl)

export const createWoocommerceIntegration = (sendData) => postAxiosRequest(getUrl(), sendData)

export const fetchWoocommerceIntegrationInstances = () => getAxiosRequest(getUrl())

export const fetchWoocommerceIntegrationInstance = (id) => getAxiosRequest(getUrl(id))

export const authWoocommerceIntegrationInstance = (id) => getAxiosRequest(getUrl(`${id}/get-redirect-url`))

export const deleteWoocommerceIntegrationInstance = (id) => deleteAxiosRequest(getUrl(id))

export const updateWoocommerceIntegrationInstance = (id, sendData) => putAxiosRequest(getUrl(id), sendData)
