import { putAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import { getUrl } from '@/support/integrations/integrationInstanceHelpers'

const URL_PREFIX = 'products'
const INTEGRATION_NAME = 'shopify'

export const mapShopifyProduct = (instanceId, sendData) => putAxiosRequest(getUrl(instanceId, INTEGRATION_NAME, URL_PREFIX, 'map'), sendData)

export const createShopifySkuProduct = (instanceId, sendData, filters = {}) => {
  let params = {}
  if (filters && filters.conjunction) params.filters = JSON.stringify(filters)
  return postAxiosRequest(getUrl(instanceId, INTEGRATION_NAME, URL_PREFIX,`create-sku-products`),sendData, {params})
}
