import {getAxiosRequest, postAxiosRequest, putAxiosRequest} from '@/support/apiRequestHelpers'
import axiosConfig from '../../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (path = '') => {
  const baseUrl = `/shipmyorders/invoices`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchSmoInvoices = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(getUrl(''), buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchSmoInvoiceByID = async (id) => {
  try {
    const { data } = await axiosConfig.get(getUrl(`${id}`))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
export const uploadSmoInvoices = (sendData) => postAxiosRequest(getUrl(''), sendData)

export const deleteSmoInvoiceByID = async (invoiceID) => {
  const url = getUrl(`${invoiceID}`)

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteSmoInvoices = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(getUrl(''), { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveSmoInvoiceByID = async (smoInvoiceID) => {
  const url = getUrl(`${smoInvoiceID}/archive`)

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveSmoInvoiceByID = async (smoInvoiceID) => {
  const url = getUrl(`${smoInvoiceID}/unarchived`)

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveSmoInvoices = async (sendData) => {
  const url = getUrl(`archive`)

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveSmoInvoices = async (sendData) => {
  const url = getUrl(`unarchive`)

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(getUrl(`deletable`), { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const processSmoInvoice = (invoiceId) => postAxiosRequest(getUrl(`${invoiceId}/process`))
export const bulkProcessSmoInvoices = (payload) => postAxiosRequest(getUrl(`process`), payload)
export const processAllSmoInvoices = () => postAxiosRequest(getUrl(`process-all`))
export const unprocessSmoInvoice = (invoiceId) => postAxiosRequest(getUrl(`${invoiceId}/unprocess`))
export const bulkUnprocessSmoInvoices = (payload) => postAxiosRequest(getUrl(`unprocess`), payload)
export const unprocessAllSmoInvoices = () => postAxiosRequest(getUrl(`unprocess-all`))

export const updateSmoInvoice = (invoiceId, sendData) => putAxiosRequest(getUrl(`${invoiceId}`), sendData)

export const getMappingRules = () => getAxiosRequest(getUrl('mapping-rules'))
export const saveMappingRules = (sendData) => postAxiosRequest(getUrl('mapping-rules'), sendData)
