import { getAxiosRequest, postAxiosRequest, putAxiosRequest, deleteAxiosRequest } from '@/support/apiRequestHelpers'

const getUrl  = (id, path = null) => {
  let url = `/sales-orders/${id}/financial-lines`
  return path ? `${url}/${path}` : url
}

export const fetchSOFinancialLines = async (orderId, params = {}) => await getAxiosRequest(getUrl(orderId), params)

export const createSOFinancialLine = async (orderId, payload) => await postAxiosRequest(getUrl(orderId), payload)

export const updateSOFinancialLine = async (orderId, lineId, payload) => await putAxiosRequest(getUrl(orderId,lineId), payload)

export const deleteSOFinancialLine = async (orderId, lineId) => await deleteAxiosRequest(getUrl(orderId,lineId))