import axiosConfig from '../../config/axiosConfig'

const baseURL = '/purchase-order-shipments'

export const getPurchaseOrderReceipts = async (id) => {
  const url = `purchase-orders/${id}/receipts`
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createPurchaseOrderShipment = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchPurchaseOrderReceiptById = async (purchaseOrderId, receiptId) => {
  const url = `purchase-orders/${purchaseOrderId}/receipts/${receiptId}`
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const receivePurchaseOrderShipment = async (sendData) => {
  const url = `${baseURL}/receive`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updatePurchaseOrderReceipt = async (id, sendData) => {
  const url = `${baseURL}/receipts/${id}`
  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePurchaseOrderReceipt = async (id) => {
  const url = `${baseURL}/receipts/${id}`
  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
