import axiosConfig from '../../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/sales-order-fulfillments'

// Get All Fulfillments
export const getAllFulfillments = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Sales Order Line
export const deleteFulfillmentByID = async (fulfillmentId) => {
  const url = `${baseURL}/${fulfillmentId}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}


export const deleteFulfillments = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// check sales orders deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveFulfillmentByID = async (fulfillmentId) => {
  const url = `${baseURL}/${fulfillmentId}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveFulfillmentByID = async (fulfillmentId) => {
  const url = `${baseURL}/${fulfillmentId}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}


export const archiveFulfillments = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveFulfillments = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
      return Promise.reject(e)
  }
}

export const updateTrackingStatuses = async (sendData) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/tracking-updates`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const markAsPrinted = async (id) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${id}/mark-as-printed`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
