import {postAxiosRequest, getAxiosRequest, putAxiosRequest, deleteAxiosRequest} from '@/support/apiRequestHelpers'

const baseUrl = '/ebay'

const getUrl = (path = '') => (path ? `${baseUrl}/${path}` : baseUrl)

export const createEbayIntegration = (sendData) => postAxiosRequest(getUrl(), sendData)

export const fetchEbayIntegrationInstances = () => getAxiosRequest(getUrl())

export const fetchEbayIntegrationInstance = (id) => getAxiosRequest(getUrl(id))

export const authEbayIntegrationInstance = (id) => getAxiosRequest(getUrl(`${id}/get-redirect-url`))

export const deleteEbayIntegrationInstance = (id) => deleteAxiosRequest(getUrl(id))

export const updateEbayIntegrationInstance = (id, sendData) => putAxiosRequest(getUrl(id), sendData)
