import { postAxiosRequest, getAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `/ebay/${instanceId}/orders`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchEbayOrders = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const refreshEbayOrders = (instanceId) => postAxiosRequest(getUrl(instanceId, 'refresh'))

export const fetchEbayOrderById = (instanceId, id) => getAxiosRequest(getUrl(instanceId, id))

export const createEbaySkuOrder = (instanceId, sendData) => postAxiosRequest(getUrl(instanceId, 'create-sku-orders'), sendData)
