import { postAxiosRequest, getAxiosRequest, putAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (path = '') => {
  const baseUrl = `/ebay-global-reports`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const getUncoveredBlemishedProducts = () => getAxiosRequest(getUrl('uncovered-blemished-products'))
export const getListedBlemishedProductsOutOfStock = () => getAxiosRequest(getUrl('listed-blemished-products-out-of-stock'))
