import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/users'

export const getAllUsers = async (query) => {
  try {
    return await axiosConfig.get(baseURL, buildUrlParams(query))
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createUser = async (data) => {
  try {
    return await axiosConfig.post(`${baseURL}/store-user`, data)
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateUser = async (data) => {
  try {
    return await axiosConfig.put(`${baseURL}/${data.id}`, data)
  } catch (e) {
    return Promise.reject(e)
  }
}

export const toggleUserActivation = async (id) => {
  try {
    return await axiosConfig.delete(`${baseURL}/${id}`)
  } catch (e) {
    return Promise.reject(e)
  }
}
