import axiosConfig from '../config/axiosConfig'

const baseURL = '/store-file'

export const postFile = async (file, config) => {
  try {
    config = config || {}

    let onProgress = config.onProgress
      ? config.onProgress : x => x

    let destination = config.destination
      ? config.destination : 'default'

    let formData = new FormData()

    formData.append('file', file)
    formData.append('destination', destination)

    return axiosConfig.post(baseURL, formData, {
      headers: {
        'Content-Type': 'multipart/form-data'
      },
      onUploadProgress: onProgress
    })
  } catch (e) {
    return Promise.reject(e)
  }
}
