import axiosConfig from '@/config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/tax-rates'

// get Tax Rates
export const getTaxRates = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Tax Rate
export const createTaxRate = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, sendData)
    return data
  } catch (e) {
    return Promise.reject(e.response)
  }
}

// Archive Tax Rates By IDs
export const archiveTaxRates = async (sendData) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/archive`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Archive Tax Rates By IDs
export const getArchiveTaxRates = async (sendData) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/archive`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// unArchive Tax Rates By IDs
export const unArchiveTaxRates = async (sendData) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/unarchive`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// get unArchive Tax Rates By IDs
export const getUnArchiveTaxRates = async (sendData) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/unarchive`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// delete Tax Rates
export const deleteTaxRates = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { data: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// delete Tax Rates By IDs
export const deleteTaxRateById = async (taxRateId) => {
  try {
    const { data } = await axiosConfig.delete(`${baseURL}/${taxRateId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// get Tax Rates
export const fetchTaxRatesForMapping = async () => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}?included=["name","rate"]&limit=-1`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const accountingMapTaxRates = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/accounting-mapping`, sendData)
    return data
  } catch (e) {
    console.log(e)
    return Promise.reject(e)
  }
}
