import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/tags'

export const getAllTags = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Tag
export const createTag = async (tagData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...tagData })
    return data
  } catch (e) {
    if (e) {
      return e.response
    }
  }
}

// Update Tag
export const updateTag = async (tagID, tagData) => {
  const url = `${baseURL}/${tagID}`

  try {
    const { data } = await axiosConfig.put(url, { ...tagData })
    return data
  } catch (e) {
    if (e) {
      return e.response
    }
  }
}

// Archive By ID
export const archiveByID = async (ID) => {
  const url = `${baseURL}/${ID}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveByID = async (ID) => {
  const url = `${baseURL}/${ID}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Archive By IDs or filter
export const archive = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Unarchive By IDs or filter
export const unarchive = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete By ID
export const deleteByID = async (incotermID) => {
  const url = `${baseURL}/${incotermID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete  By IDs or filter
export const bulkDelete = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk check deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const previewTagsImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importTagsData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
