import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/shipping-methods'

// Get All Shipping Methods
export const getAllShippingMethod = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getShippingMethodByID = async (ID) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${ID}`)

    // Bind in name for display
    data.data.name = `${data.data.carrier_name} (${data.data.method_name})`
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Nominal Code
export const createShippingMethod = async (shippingMethodData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...shippingMethodData })
    return data
  } catch (e) {

    if (e.response) {
      return e.response
    }
  }
}

// Update Shipping Method
export const updateShippingMethod = async (ID, ShippingMethodData) => {
  const url = `${baseURL}/${ID}`

  try {
    const { data } = await axiosConfig.put(url, { ...ShippingMethodData })
    return data
  } catch (e) {

    if (e.response) {
      return e.response
    }
  }
}

// Archive By ID
export const archiveByID = async (ID) => {
  const url = `${baseURL}/${ID}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveByID = async (ID) => {
  const url = `${baseURL}/${ID}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Archive By IDs or filter
export const archive = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Unarchive By IDs or filter
export const unarchive = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete By ID
export const deleteByID = async (ID) => {
  const url = `${baseURL}/${ID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete  By IDs or filter
export const bulkDelete = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk check deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const previewShippingMethodsImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importShippingMethodsData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
