import axiosConfig from '../config/axiosConfig'

const baseURL = '/channels'

// Get Sales Channels Types
export const getSalesChannelTypes = async () => {
  const url = `${baseURL}/types`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Sales Channel
export const createSalesChannel = async (salesChannelData) => {
  const url = `${baseURL}`

  try {
    const { data } = await axiosConfig.post(url, salesChannelData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Check Sales Channel Credentials
export const checkSalesChannelCredentials = async (salesChannelsCredentials) => {
  const url = `${baseURL}/check-credentials`

  try {
    const { data } = await axiosConfig.post(url, salesChannelsCredentials)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Get Amazon Developer ID
export const getAmazonDeveloperID = async (marketPlaceID) => {
  const url = `${baseURL}/amazon/developerId/${marketPlaceID}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Generate Ebay OAuth URL
export const generateEbayOAuthURL = async () => {
  const url = `${baseURL}/ebay/generate-oauth-url`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Generate Google Express OAuth URL
export const generateGoogleExpressOAuthURL = async () => {
  const url = `${baseURL}/google-express/generate-oauth-url`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Generate Magento OAuth URL
export const generateMagentoOAuthURL = async () => {
  const url = `${baseURL}/magento/generate-oauth-url`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Generate Shopify OAuth URL
export const generateShopifyOAuthURL = async (shopifyShop) => {
  const url = `${baseURL}/shopify/generate-oauth-url/${shopifyShop}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Check if OAuth App is Installed
export const isOAuthAppInstalled = async (state) => {
  const url = `${baseURL}/oauth-app-installed/${state}`

  try {
    return axiosConfig.get(url)
  } catch (e) {
    return Promise.reject(e)
  }
}

// Auth Accepted From Ebay
export const isEbayAuthAccepted = async (query) => {
  const url = `${baseURL}/ebay/auth-accepted`

  try {
    const { data } = axiosConfig.get(url, query)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Auth Accepted From Google Express
export const isGoogleExpressAuthAccepted = async (query) => {
  const url = `${baseURL}/google-express/auth-accepted`

  try {
    const { data } = axiosConfig.get(url, query)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
