import axiosConfig from '../config/axiosConfig'

const baseURL = '/return-reasons'

export const getReturnReasons = async () => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createReturnReason = async (payload) => {
  try {
    const { data } = await axiosConfig.post(baseURL, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateReturnReason = async (reasonId, payload) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${reasonId}`, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteReturnReason = async (reasonId) => {
  const url = `${baseURL}/${reasonId}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const isReasonDeletable = async (reasonId) => {
  const url = `${baseURL}/deletable`

  try {
    const { data } = await axiosConfig.post(url, { ids: [reasonId] })
    return data.data[0]
  } catch (e) {
    return Promise.reject(e)
  }
}
