import axiosConfig from '../config/axiosConfig'

const baseURL = '/report-templates'

// Get All Report Templates
export const getAllReportTemplates = async () => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data.data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create New Template
export const createTemplate = async (templateData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...templateData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Update Template
export const updateTemplate = async (templateID, templateData) => {
  const url = `${baseURL}/${templateID}`

  try {
    const { data } = await axiosConfig.put(url, { ...templateData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Template
export const deleteTemplate = async (templateID) => {
  const url = `${baseURL}/${templateID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
