import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/product-brands'

// Get Product Brands
export const getAllProductBrands = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Get Product Brand By ID
export const getProductBrandByID = async (productBrandID) => {
  const url = `${baseURL}/${productBrandID}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Product Brand
export const createProductBrand = async (productBrandData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...productBrandData })
    return data
  } catch (e) {
    if (e.response) {
      return e.response
    }
  }
}

// Update Product Brand
export const updateProductBrand = async (productBrandID, productBrandData) => {
  const url = `${baseURL}/${productBrandID}`

  try {
    const { data } = await axiosConfig.put(url, { ...productBrandData })
    return data
  } catch (e) {
    if (e.response) {
      return e.response
    }
  }
}

// Archive Product Brand By ID
export const archiveProductBrandByID = async (productBrandID) => {
  const url = `${baseURL}/${productBrandID}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveProductBrandByID = async (productBrandID) => {
  const url = `${baseURL}/${productBrandID}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Archive Product Brands By IDs or filter
export const archiveProductBrands = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Unarchive Product Brands By IDs or filter
export const unarchiveProductBrands = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Product Brand By ID
export const deleteProductBrandByID = async (productBrandID) => {
  const url = `${baseURL}/${productBrandID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Product Brands By IDs or filter
export const deleteProductBrands = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk check deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const previewBrandsImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importBrandsData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
