import axiosConfig from '../config/axiosConfig'

const baseURL = '/notes'
export const getNotes = async (payload) => {
  try {
    const queryParams = new URLSearchParams(payload).toString()
    const {data} = await axiosConfig.get(`${baseURL}?${queryParams}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const addNote = async (payload) => {
  try {
    const {data} = await axiosConfig.post(baseURL, {...payload})
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteNote = async (noteId) => {
  try {
    const {data} = await axiosConfig.delete(`${baseURL}/${noteId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
