import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'
import { getAxiosRequest } from '@/support/apiRequestHelpers'

const baseURL = '/inventory-movements'

export const getAllInventoryMovements = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getProductInventoryMovements = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(`/products/${options.productId}/inventory-movements`, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getInventoryTransferById = async (transferId) => {
  const transferBaseURL = 'warehouses/transfers'
  try {
    const { data } = await axiosConfig.get(`${transferBaseURL}/${transferId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const showTallies = async (params) => {
  return await getAxiosRequest(`${baseURL}/tallies`, { params })
}
