import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/inventory/forecast'

export const getPurchaseOrderSuggestions = async (options) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const refreshForecasting = async () => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/refresh`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createPurchaseOrdersFromForecasting = async (payload) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/purchase-orders`, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getForecastingStatus = async () => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/status`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getForecastingGrandTotalCost = async () => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/total-cost`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
