import {getAxiosRequest, postAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/financials'

export const getTopProducts = async (params) => {
  return await getAxiosRequest(`${baseURL}/top-products`, { params })
}

export const getFinancialsSummaryByPeriod = async (params) => {
  return await getAxiosRequest(`${baseURL}/summary-by-period`,{ params })
}

export const getProductFinancialsSummaryByPeriod = async(id, params) => {
  return await getAxiosRequest(`${baseURL}/products/${id}/summary-by-period`,{ params })
}

export const getSalesOrderLinesFinancials = async (query) => {
  const params = buildUrlParams(query, true)
  const queryParams = params.hasOwnProperty('params') ? params : { params }
  return await getAxiosRequest(`${baseURL}/sales-order-lines`,queryParams)
}

export const getDailyFinanacialSummary = async (query) => {
  const params = buildUrlParams(query, true)
  const queryParams = params.hasOwnProperty('params') ? params : { params }
  return await getAxiosRequest(`${baseURL}/daily-summary`,queryParams)
}

export const recalculateSalesOrderLineFinancials = (payload) => postAxiosRequest(`${baseURL}/sales-order-line-financials/recalculate-lines`, payload)
export const recalculateDailyFinancialSummaries = (payload) => postAxiosRequest(`${baseURL}/daily-financials/recalculate`, payload)
