import {getAxiosRequest, postAxiosRequest, putAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/financial-alerts'

export const getFinancialAlerts = async (query) => {
  const params = buildUrlParams(query, true)
  const queryParams = params.hasOwnProperty('params') ? params : { params }
  return await getAxiosRequest(`${baseURL}`, queryParams)
}

export const updateFinancialAlert = (id, data) => putAxiosRequest(`${baseURL}/${id}`, data)

export const archiveFinancialAlert = (id) => putAxiosRequest(`${baseURL}/${id}/archive`)

export const unarchiveFinancialAlert = (id) => putAxiosRequest(`${baseURL}/${id}/unarchive`)

export const processFinancialAlerts = () => postAxiosRequest(`${baseURL}/process`)

export const createFinancialAlertClassification = (payload) => postAxiosRequest(`${baseURL}/classifications`, payload)

export const getFinancialAlertClassifications = async () => {
  return await getAxiosRequest(`${baseURL}/classifications`)
}

export const getFinancialAlertsDashboardData = () => getAxiosRequest(`${baseURL}/dashboard`)
