import axiosConfig from '../config/axiosConfig'

const baseURL = '/currencies'

export const getCurrencies = async () => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data.data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createCurrency = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateCurrency = async ({ sendData, id }) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${id}`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteCurrency = async (id) => {
  try {
    const { data } = await axiosConfig.delete(`${baseURL}/${id}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const bulkDeleteCurrencies = async (ids) => {
  try {
    const { data } = await axiosConfig.delete(`${baseURL}`, { data: ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const setDefaultCurrency = async (id) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${id}/set-default`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const bulkUpdateCurrencies = async (sendData) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/bulk-update`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletable = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
