import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/backorder-queues'

export const getBackorderQueues = async (options) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const loadBackorderQueueById = async (id) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${id}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getBackorderHistory = async (id) => {
  try {
    const url = `${baseURL}/${id}/history`
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const reorderBackorder = async (id, sendData) => {
  const url = `${baseURL}/${id}/reorder`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const reorderBackorders = async (sendData) => {
  const url = `${baseURL}/reorder-bulk`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const switchSupplier = async (backorderId, supplierId) => {
  const url = `${baseURL}/${backorderId}/switch-supplier`
  try {
    const { data } = await axiosConfig.put(url, { supplier_id: supplierId })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const switchSuppliers = async (sendData) => {
  const url = `${baseURL}/switch-suppliers`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchBackorderQueueById = async (id) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${id}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveBackorderQueueByID = async (id) => {
  const url = `${baseURL}/${id}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveBackorderQueueByID = async (id) => {
  const url = `${baseURL}/${id}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveBackorderQueues = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveBackorderQueues = async (sendData) => {
  const url = `${baseURL}/unarchive`
  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const reAllocateBackorder = async (sendData, id) => {
  const url = `${baseURL}/releases/${id}/re-allocate`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
