import { getAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `restock-report`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchAmazonRestocks = ({ instanceId }, params) => getAxiosRequest(getUrl(`${instanceId}`), buildUrlParams(params))

export const fetchAmazonRestock = (instanceId, restockId) => getAxiosRequest(getUrl(`${instanceId}`, `${restockId}`))
