import { getAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `reports`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

const getRequestUrl = (instanceId, path = '') => {
  const baseUrl = `report-requests`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const getInfo = (instanceId, params) => getAxiosRequest(getUrl(instanceId, 'get-info'), buildUrlParams(params))
export const syncReport = (instanceId, id) => postAxiosRequest(getUrl(instanceId, `${id}/sync`))
export const createReport = (instanceId, requestId) => postAxiosRequest(getRequestUrl(instanceId, `${requestId}/create-report`))
export const createNextRequest = (instanceId, data) => postAxiosRequest(getRequestUrl(instanceId, `create-next`), data)
