import { getAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `removal-orders`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchAmazonInventoryRemovalOrders = ({ instanceId }, params) => getAxiosRequest(getUrl(`${instanceId}`), buildUrlParams(params))

export const fetchAmazonInventoryRemovalOrder = (instanceId, removalOrderId) => getAxiosRequest(getUrl(`${instanceId}`, `${removalOrderId}`))

export const processAll = (instanceId) => postAxiosRequest(getUrl(instanceId, `process-all`))

export const process = (instanceId, params) => postAxiosRequest(getUrl(instanceId, `process`), params)

export const unprocess = (instanceId, params) => postAxiosRequest(getUrl(instanceId, `unprocess`), params)

export const markItemAsUnknown = (instanceId, removalOrderId) => postAxiosRequest(getUrl(instanceId, `${removalOrderId}/mark-item-as-unknown`))

export const unmarkItemAsUnknown = (instanceId, removalOrderId) => postAxiosRequest(getUrl(instanceId, `${removalOrderId}/unmark-item-as-unknown`))
